/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface CanvasGradient;
interface CanvasPattern;
interface HitRegionOptions;
interface HTMLCanvasElement;
interface HTMLImageElement;
interface HTMLVideoElement;
interface ImageData;
interface TextMetrics;
interface Window;
interface XULElement;

interface CanvasRenderingContext2D {

  // back-reference to the canvas
  [Infallible]
  readonly attribute HTMLCanvasElement canvas;

  // state
  [Infallible]
  void save(); // push state on state stack
  [Infallible]
  void restore(); // pop state stack and restore state

  // transformations (default transform is the identity matrix)
// NOT IMPLEMENTED           attribute SVGMatrix currentTransform;
  void scale(double x, double y);
  void rotate(double angle);
  void translate(double x, double y);
  void transform(double a, double b, double c, double d, double e, double f);
  void setTransform(double a, double b, double c, double d, double e, double f);
// NOT IMPLEMENTED  void resetTransform();

  // compositing
           [Infallible]
           attribute double globalAlpha; // (default 1.0)
           attribute DOMString globalCompositeOperation; // (default source-over)

  // colors and styles (see also the CanvasDrawingStyles interface)
           [SetterInfallible]
           attribute any strokeStyle; // (default black)
           [SetterInfallible]
           attribute any fillStyle; // (default black)
  CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1);
  CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1);
  CanvasPattern createPattern((HTMLImageElement or HTMLCanvasElement or HTMLVideoElement) image, DOMString? repetition);

  // shadows
           [Infallible]
           attribute double shadowOffsetX; // (default 0)
           [Infallible]
           attribute double shadowOffsetY; // (default 0)
           [Infallible]
           attribute double shadowBlur; // (default 0)
           [Infallible]
           attribute DOMString shadowColor; // (default transparent black)

  // rects
  [Infallible]
  void clearRect(double x, double y, double w, double h);
  [Infallible]
  void fillRect(double x, double y, double w, double h);
  [Infallible]
  void strokeRect(double x, double y, double w, double h);

  // path API (see also CanvasPathMethods)
  [Infallible]
  void beginPath();
  [Infallible]
  void fill();
// NOT IMPLEMENTED  void fill(Path path);
  [Infallible]
  void stroke();
// NOT IMPLEMENTED  void stroke(Path path);
// NOT IMPLEMENTED  void drawSystemFocusRing(Element element);
// NOT IMPLEMENTED  void drawSystemFocusRing(Path path, Element element);
// NOT IMPLEMENTED  boolean drawCustomFocusRing(Element element);
// NOT IMPLEMENTED  boolean drawCustomFocusRing(Path path, Element element);
// NOT IMPLEMENTED  void scrollPathIntoView();
// NOT IMPLEMENTED  void scrollPathIntoView(Path path);
  [Infallible]
  void clip();
// NOT IMPLEMENTED  void clip(Path path);
// NOT IMPLEMENTED  void resetClip();
  [Infallible]
  boolean isPointInPath(double x, double y);
// NOT IMPLEMENTED  boolean isPointInPath(Path path, double x, double y);

  // text (see also the CanvasDrawingStyles interface)
  void fillText(DOMString text, double x, double y, optional double maxWidth);
  void strokeText(DOMString text, double x, double y, optional double maxWidth);
  TextMetrics measureText(DOMString text);

  // drawing images
// NOT IMPLEMENTED           attribute boolean imageSmoothingEnabled; // (default true)
  void drawImage((HTMLImageElement or HTMLCanvasElement or HTMLVideoElement) image, double dx, double dy);
  void drawImage((HTMLImageElement or HTMLCanvasElement or HTMLVideoElement) image, double dx, double dy, double dw, double dh);
  void drawImage((HTMLImageElement or HTMLCanvasElement or HTMLVideoElement) image, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh);

  // hit regions
// NOT IMPLEMENTED  void addHitRegion(HitRegionOptions options);

  // pixel manipulation
  [Creator] ImageData createImageData(double sw, double sh);
  [Creator] ImageData createImageData(ImageData imagedata);
  [Creator] ImageData getImageData(double sx, double sy, double sw, double sh);
  void putImageData(ImageData imagedata, double dx, double dy);
  void putImageData(ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY, double dirtyWidth, double dirtyHeight);

  // Mozilla-specific stuff
  // FIXME Bug 768048 mozCurrentTransform/mozCurrentTransformInverse should return a WebIDL array.
  attribute object mozCurrentTransform; // [ m11, m12, m21, m22, dx, dy ], i.e. row major
  attribute object mozCurrentTransformInverse;

  [Infallible]
  attribute DOMString mozFillRule; /* "evenodd", "nonzero" (default) */

  attribute any mozDash; /* default |null| */

  [Infallible]
  attribute double mozDashOffset; /* default 0.0 */

  [GetterInfallible]
  attribute DOMString mozTextStyle;

  // image smoothing mode -- if disabled, images won't be smoothed
  // if scaled.
  [Infallible]
  attribute boolean mozImageSmoothingEnabled;

  // Show the caret if appropriate when drawing
  const unsigned long DRAWWINDOW_DRAW_CARET   = 0x01;
  // Don't flush pending layout notifications that could otherwise
  // be batched up
  const unsigned long DRAWWINDOW_DO_NOT_FLUSH = 0x02;
  // Draw scrollbars and scroll the viewport if they are present
  const unsigned long DRAWWINDOW_DRAW_VIEW    = 0x04;
  // Use the widget layer manager if available. This means hardware
  // acceleration may be used, but it might actually be slower or
  // lower quality than normal. It will however more accurately reflect
  // the pixels rendered to the screen.
  const unsigned long DRAWWINDOW_USE_WIDGET_LAYERS = 0x08;
  // Don't synchronously decode images - draw what we have
  const unsigned long DRAWWINDOW_ASYNC_DECODE_IMAGES = 0x10;

  /**
   * Renders a region of a window into the canvas.  The contents of
   * the window's viewport are rendered, ignoring viewport clipping
   * and scrolling.
   *
   * @param x
   * @param y
   * @param w
   * @param h specify the area of the window to render, in CSS
   * pixels.
   *
   * @param backgroundColor the canvas is filled with this color
   * before we render the window into it. This color may be
   * transparent/translucent. It is given as a CSS color string
   * (e.g., rgb() or rgba()).
   *
   * @param flags Used to better control the drawWindow call.
   * Flags can be ORed together.
   *
   * Of course, the rendering obeys the current scale, transform and
   * globalAlpha values.
   *
   * Hints:
   * -- If 'rgba(0,0,0,0)' is used for the background color, the
   * drawing will be transparent wherever the window is transparent.
   * -- Top-level browsed documents are usually not transparent
   * because the user's background-color preference is applied,
   * but IFRAMEs are transparent if the page doesn't set a background.
   * -- If an opaque color is used for the background color, rendering
   * will be faster because we won't have to compute the window's
   * transparency.
   *
   * This API cannot currently be used by Web content. It is chrome
   * only.
   * FIXME Bug 767931 - Mark drawWindow and asyncDrawXULElement as ChromeOnly
   *                    in WebIDL
   */
  void drawWindow(Window window, double x, double y, double w, double h,
                  DOMString bgColor, optional unsigned long flags = 0);
  void asyncDrawXULElement(XULElement elem, double x, double y, double w,
                           double h, DOMString bgColor,
                           optional unsigned long flags = 0);
};
CanvasRenderingContext2D implements CanvasDrawingStyles;
CanvasRenderingContext2D implements CanvasPathMethods;

[NoInterfaceObject]
interface CanvasDrawingStyles {
  // line caps/joins
           [Infallible]
           attribute double lineWidth; // (default 1)
           [Infallible]
           attribute DOMString lineCap; // "butt", "round", "square" (default "butt")
           [SetterInfallible]
           attribute DOMString lineJoin; // "round", "bevel", "miter" (default "miter")
           [Infallible]
           attribute double miterLimit; // (default 10)

  // dashed lines
// NOT IMPLEMENTED    void setLineDash(sequence<double> segments); // default empty
// NOT IMPLEMENTED    sequence<double> getLineDash();
// NOT IMPLEMENTED             attribute double lineDashOffset;

  // text
           [GetterInfallible]
           attribute DOMString font; // (default 10px sans-serif)
           [Infallible]
           attribute DOMString textAlign; // "start", "end", "left", "right", "center" (default: "start")
           [Infallible]
           attribute DOMString textBaseline; // "top", "hanging", "middle", "alphabetic", "ideographic", "bottom" (default: "alphabetic")
};

[NoInterfaceObject]
interface CanvasPathMethods {
  // shared path API methods
  [Infallible]
  void closePath();

  [Infallible]
  void moveTo(double x, double y);

  [Infallible]
  void lineTo(double x, double y);

  [Infallible]
  void quadraticCurveTo(double cpx, double cpy, double x, double y);

  [Infallible]
  void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y);

  void arcTo(double x1, double y1, double x2, double y2, double radius); 
// NOT IMPLEMENTED  void arcTo(double x1, double y1, double x2, double y2, double radiusX, double radiusY, double rotation);

  [Infallible]
  void rect(double x, double y, double w, double h);

  void arc(double x, double y, double radius, double startAngle, double endAngle, optional boolean anticlockwise = false); 
// NOT IMPLEMENTED  void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise);
};
