/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerStub {
    public OncRpcServerTransport[] transports;
    public OncRpcServerTransportRegistrationInfo[] info;
    protected Object shutdownSignal = new Object();

    public void run() throws IOException, OncRpcException {
        this.unregister(this.transports);
        this.register(this.transports);
        this.run(this.transports);
        this.unregister(this.transports);
        this.close(this.transports);
    }

    public void register(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].register();
        }
    }

    public void run(OncRpcServerTransport[] transports) {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].listen();
        }
        while (true) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                try {
                    this.shutdownSignal.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void stopRpcProcessing() {
        if (this.shutdownSignal != null) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                this.shutdownSignal.notify();
            }
        }
    }

    public void unregister(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].unregister();
        }
    }

    public void close(OncRpcServerTransport[] transports) {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].close();
        }
    }
}

