
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2008 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KXSLDBG_H
#define KXSLDBG_H

#include <kapplication.h>
#include <kparts/mainwindow.h>

class KToggleAction;

/**
 * This is the application "Shell".  It has a menubar, toolbar, and
 * statusbar but relies on the "Part" to do all the real work.
 *
 * @short Application Shell
 * @author Keith Isdale <keith@kdewebdev.org>
 * @version 0.4
 */
class KXsldbg : public KParts::MainWindow
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    KXsldbg();

    /**
     * Default Destructor
     */
    virtual ~KXsldbg();

protected:
    virtual bool closeUrl();

public slots:
    void quit();
    void newCursorPosition(const QString &file, int lineNumber, int columnNumber);
    void newDebuggerPosition(const QString & file, int lineNumber);

private slots:
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();

    void applyNewToolbarConfig();


private:
    void setupAccel();
    void setupActions();

private:
    KParts::ReadOnlyPart *m_part;

    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
};

#endif // KXSLDBG_H
