/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2008 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_PIMO_H_
#define _SOPRANO_PIMO_H_

#include <QtCore/QUrl>

namespace Nepomuk {
    namespace Vocabulary {
        /**
         * This is an excerpt of the PIMO ontology as used in the Nepomuk core library.
         *
         * The complete ontology can be found in kdebase/runtime/nepomuk/ontologies
         */
        namespace PIMO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#
             */
            QUrl pimoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Thing 
             * 
             * Entities that are in the direct attention of the user when doing 
             * knowledge work. 
             */
            QUrl Thing();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#groundingOccurrence 
             * 
             * The subject Thing represents the entity that is described in 
             * the object InformationElement. The subject Thing is the canonical, 
             * unique representation in the personal information model for 
             * the entity described in the object. Multiple InformationElements 
             * can be the grounding occurrence of the same Thing, one InformationElement 
             * can be the groundingOccurrence of only one Thing. 
             */
            QUrl groundingOccurrence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#occurrence 
             * 
             * The subject Thing is represented also in the object resource. 
             * All facts added to the object resource are valid for the subject 
             * thing. The subject is the canonical represtation of the object. 
             * In particual, this implies when (?object ?p ?v) -> (?subject 
             * ?p ?v) and (?s ?p ?object) -> (?s ?p ?subject). The class of the 
             * object is not defined, but should be compatible with the class 
             * of the subject. Occurrence relations can be inferred through 
             * same identifiers or referencingOccurrence relations. 
             */
            QUrl occurrence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#referencingOccurrence 
             * 
             * The subject thing is described in the object document. Ideally, 
             * the document is public and its primary topic is the thing. Although 
             * this property is not inverse-functional (because the Occurrences 
             * are not canonical elements of a formal ontology) this property 
             * allows to use public documents, such as wikipedia pages, as 
             * indicators identity. The more formal hasOtherRepresentation 
             * property can be used when an ontology about the subject exists. 
             */
            QUrl referencingOccurrence();
        }
    }
}

#endif
