.TH XvQueryAdaptors __libmansuffix__  __vendorversion__
.SH Name
XvQueryAdaptors \- return adaptor information for a screen
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "XvQueryAdaptors(Display *" dpy ", Window " window ",
.BI "                unsigned int *" p_num_adaptors ",
.BI "                XvAdaptorInfo **" pp_adaptor_info ");"
.fi
.SH Arguments
.\"
.IP \fIdpy\fR 8
Specifies the connection to the X server.
.IP \fIwindow\fR 8
Specifies a window of the screen for which the adaptor 
information is desired.
.IP \fIp_num_adaptors\fR 8
A pointer to where the number of adaptors for the specified screen 
is returned.
.IP \fIpp_adaptor_info\fR 8
A pointer to where the list of returned adaptor information is
returned.
.\"
.SH Description
.\"
XvQueryAdaptors(__libmansuffix__) returns an video adaptor information for
the screen of the specified drawable.  The XvAdaptorInfo structure
has the following organization:
.EX

     typedef struct {
       XvPortID base_id;
       unsigned long num_ports;
       char type;
       char *name;
       unsigned long num_formats;
       XvFormat *formats;
       unsigned long num_adaptors;
     } XvAdaptorInfo;

.EE
.IP \fIbase_id\fR 8
The resource ID of the first adaptor port.
.IP \fInum_ports\fR 8
The number of ports supported by the adaptor.
.IP \fItype\fR 8
A bit mask with the value XvInputMask asserted if the adaptor supports video
input, and value XvOutputMask asserted if the adaptor supports video output.
.IP \fIname\fR 8
A vendor specific name that identifies the adaptor.
.IP \fInum_formats\fR 8
The number of depth/visual id formats supported by the adaptor.
.IP \fIformats\fR 8
A pointer to an array of XvFormat structures.
.PP
The XvFormat structure has the following organization:
.EX

     typedef struct {
       char depth;
       unsigned long visual_id;
     } XvFormat;

.EE
.IP \fIdepth\fR 8
A drawable depth supported by the adaptor.
.IP \fIvisual_id\fR 8
A visual-id supported for the given depth by the adaptor.
.\"
.SH Returned Values
.IP [Success] 8
Returned if XvQueryAdaptors(__libmansuffix__) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvQueryAdaptors(__libmansuffix__) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [Drawable] 8
Returned if the requested drawable does not exist.
.SH See Also
XvFreeAdaptorInfo(__libmansuffix__)
.\"
