.\" $XdotOrg: xc/doc/man/Xp/XpGetPageDimensions.man,v 1.1 2004/05/22 06:27:25 alanc Exp $
.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004 Sun Microsystems, Inc.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpGetPageDimensions 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpGetPageDimensions \-  Gets the page dimensions for the current printer 
settings.
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]	
.br
      #include <X11/extensions/Print.h>
.LP    
.B Status XpGetPageDimensions
(
.I display,
.I print_context,
.I width,
.I height,
.I reproducible_area
)
.br
      Display *\fIdisplay\fP\^;
.br
      XPContext \fIprint_context\fP\^;
.br
      unsigned short *\fIwidth\fP\^;
.br
      unsigned short *\fIheight\fP\^;
.br
      XRectangle *\fIreproducible_area\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I print_context
A pre-existing print context.
.TP
.I width
Returns the pixel width of the page currently selected in the print context.
.TP
.I height
Returns the pixel height of the page currently selected in the print context.
.TP
.I reproducible_area
Returns the net reproducible area of the page currently selected in the print 
context, expressed in pixel offsets and dimensions.
.SH DESCRIPTION
.LP
XpGetPageDimensions considers the medium currently selected in the print context 
(derived in part from default-medium, default-input-tray, input-trays-medium, 
content-orientation, default-resolution), and returns the total width and height 
of the page in pixels, and the net reproducible area within the total width and 
height. The net reproducible area is the portion of the page on which the 
printer is physically capable of placing ink.

XpGetPageDimensions returns a Status of 0 on failure, or 1 on success.
.SH DIAGNOSTICS
.TP 15
.SM XPBadContext
A valid print context-id has not been set prior to making this call.
