/* $Id: xfce-gtk-extensions.c 1440 2004-08-15 19:39:48Z olivier $ */
/*-
 * Copyright (c) 2004 Benedikt Meurer <benny@xfce.org>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libxfcegui4/xfce-gdk-extensions.h>
#include <libxfcegui4/xfce-gtk-extensions.h>


/**
 * xfce_gtk_window_center_on_monitor:
 * @window: The Gtk window to center.
 * @screen: The screen on which the @window should be centered.
 * @monitor: The monitor of the @screen on which @window should be centered.
 *
 * Centers @window on @monitor of @screen. @monitor has to reference a valid
 * monitor of @screen.
 *
 * Since: 4.2
 **/
void
xfce_gtk_window_center_on_monitor (GtkWindow *window,
			                             GdkScreen *screen,
                         			     gint       monitor)
{
	GtkRequisition requisition;
	GdkRectangle   geometry;
        GdkScreen     *widget_screen;
	gint           x, y;

	gdk_screen_get_monitor_geometry (screen, monitor, &geometry);
        
        /* 
         * Getting a size request requires the widget
         * to be associated with a screen, because font
         * information may be needed (Olivier).
         */
        widget_screen = gtk_widget_get_screen (GTK_WIDGET (window));
        if (screen != widget_screen)
          {
            gtk_window_set_screen (GTK_WINDOW (window), screen);
          }
        /*
         * We need to be realized, otherwise we may get 
         * some odd side effects (Olivier). 
         */
        if (!GTK_WIDGET_REALIZED (GTK_WIDGET (window)))
	  {
            gtk_widget_realize (GTK_WIDGET (window));
          }
        /*
         * Yes, I know -1 is useless here (Olivier).
         */
        requisition.width = requisition.height = -1;
	gtk_widget_size_request (GTK_WIDGET (window), &requisition);

	x = geometry.x + (geometry.width - requisition.width) / 2;
	y = geometry.y + (geometry.height - requisition.height) / 2;

        gtk_window_move (window, x, y);
}


/**
 * xfce_gtk_window_center_on_monitor_with_pointer:
 * @window: The Gtk window to center.
 *
 * Determines the monitor that contains the pointer and centers the
 * @window on it. If it failes to determine the current pointer position,
 * @window is centered on the first monitor of the default screen on
 * the default display.
 */
void
xfce_gtk_window_center_on_monitor_with_pointer (GtkWindow *window)
{
  GdkScreen *screen;
  gint       monitor;

  screen = xfce_gdk_display_locate_monitor_with_pointer (NULL, &monitor);
  if (screen == NULL)
    {
      screen = gdk_screen_get_default ();
      monitor = 0;
    }

  xfce_gtk_window_center_on_monitor (window, screen, monitor);
}



