/* This file is part of the KDE project
   Copyright (C) 2004 Wilfried Huss <Wilfried.Huss@gmx.at>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef MARKLIST_H
#define MARKLIST_H

#include <qcheckbox.h>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qptrvector.h>

#include "pageNumber.h"

class QLabel;
class KPopupMenu;

class documentPageCache;

class MarkList;
class MarkListWidget;


/****** ThumbnailWidget ******/


class ThumbnailWidget : public QWidget
{
  Q_OBJECT

public:
  ThumbnailWidget(MarkListWidget* parent_, PageNumber _pageNumber, documentPageCache*);

private:
  virtual void paintEvent(QPaintEvent*);
  virtual void resizeEvent(QResizeEvent*);

  void setThumbnail();

private:
  PageNumber pageNumber;

  bool needsUpdating;

  documentPageCache* pageCache;

  MarkListWidget* parent;

  QPixmap thumbnail;
};


/****** MarkListWidget ******/


class MarkListWidget : public QWidget
{
  Q_OBJECT

public:
  MarkListWidget(QWidget* _parent, MarkList*, PageNumber _pageNumber, documentPageCache*, bool _showThumbnail = true);

  bool isChecked() const;

  bool isVisible();

public slots:
  void toggle();
  void setChecked( bool checked );

  void setSelected( bool selected );

  int setNewWidth(int width);

signals:
  /** Emitted when the Page is selected in the ThumbnailView. */
  void selected(PageNumber);

  /** Emitted on right click. */
  void showPopupMenu(PageNumber pageNumber, QPoint position);

protected:
  virtual void mousePressEvent(QMouseEvent*);

private:

  bool showThumbnail;

  ThumbnailWidget* thumbnailWidget;
  QCheckBox* checkBox;
  QLabel* pageLabel;
  QColor _backgroundColor;

  const PageNumber pageNumber;

  documentPageCache* pageCache;

  static const int margin = 5;

  MarkList* markList;
};


/****** MarkList ******/


class MarkList: public QScrollView
{
    Q_OBJECT

public:
  MarkList(QWidget* parent = 0, const char* name = 0);
  virtual ~MarkList();

  void setPageCache(documentPageCache*);

  QValueList<int> selectedPages() const;

  PageNumber currentPageNumber() { return currentPage; };

  PageNumber numberOfPages() { return widgetList.count(); };

public slots:
  void setNumberOfPages(int numberOfPages, bool showThumbnails = true);

  void thumbnailSelected(PageNumber pageNumber);
  void setCurrentPageNumber(PageNumber pageNumber);

  void clear();

  void slotShowThumbnails(bool);
  void repaintThumbnails(void);

protected:
  virtual void viewportResizeEvent(QResizeEvent*);

  virtual void mousePressEvent(QMouseEvent*);

signals:
  void selected(PageNumber);

private slots:
  void showPopupMenu(PageNumber pageNumber, QPoint position);

  void selectAll();
  void selectEven();
  void selectOdd();
  void toggleSelection();
  void removeSelection();

private:
  QPtrVector<MarkListWidget> widgetList;

  PageNumber currentPage;

  PageNumber clickedThumbnail;

  documentPageCache* pageCache;

  bool showThumbnails;

  KPopupMenu* contextMenu;
};

#endif
