//
// Class: documentPage
//
// Widget for displaying TeX DVI files.
// Part of KDVI- A previewer for TeX DVI files.
//
// (C) 2004 Stefan Kebekus. Distributed under the GPL.


#ifndef _documentpage_h_
#define _documentpage_h_

#include <qobject.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qstring.h>
#include <qvaluevector.h>

#include "pageNumber.h"


class Hyperlink
{
public:
  Hyperlink() {}
  Hyperlink(Q_UINT32 bl, QRect re, QString lT): baseline(bl), box(re), linkText(lT) {}

  Q_UINT32 baseline;
  QRect    box;
  QString  linkText;
};



// This class contains everything documentRenderer needs to know 
// about a certain page.
class documentPage
{
 public:
  documentPage();

  virtual ~documentPage();

  /** This method sets the number of the page that this instance
      represents. A value of '0' means that this class does not
      represent any page ('invalid page'). This method also calls
      clear(). */
  void setPageNumber(PageNumber pagenr);

  /** This method sets the number of the page that this instance
      represents. A value of '0' means that this class does not
      represent any page ('invalid page'). This method also calls
      clear(). */
  PageNumber getPageNumber() const {return pageNr;};

  /** Returns a pointer to the paintDevice (in most implementation
      either a QPixmap, or a QPrinter). The pointer returned is valid
      as long as *this documentPage exists. This method is used by the
      renderer to draw on the page. */
  virtual QPaintDevice *getPaintDevice() = 0;

  // List of source-hyperlinks in the current page. This vector is
  // generated when the current page is drawn.
  QValueVector<Hyperlink> sourceHyperLinkList;

  QValueVector<Hyperlink> textLinkList; // List of text in the window
  QValueVector<Hyperlink> hyperLinkList; // List of ordinary hyperlinks

  // set to 'false' in the constructor, set to 'true' by the renderer,
  // if something really has been rendered
  bool isEmpty;

  /** Clears the contents of the class, but leaves pageNumber intact,
      and does not free the memory for the QValueVectors so the
      lengthy re-allocation won't be necessary later. Clears the
      Pixmap. Before setPixmap() is called next time, getPixmap() will
      return 0. */
  void clear();
  
 private:
  /** Number of the page that this instance represents a value of '0'
      means that this class does not represent any page, i.e. that a
      page number has not been set yet. */
  PageNumber  pageNr;
};


#endif
