//
// Class: documentPage
//
// Widget for displaying TeX DVI files.
// Part of KDVI- A previewer for TeX DVI files.
//
// (C) 2004 Stefan Kebekus. Distributed under the GPL.

#include <kdebug.h>

#include "documentPage.h"

documentPage::documentPage() 
{
  sourceHyperLinkList.reserve(200);
  textLinkList.reserve(250);
  pageNr = 0;
  isEmpty = true;
}


documentPage::~documentPage() 
{
  ;
}


void documentPage::setPageNumber(PageNumber pnr)
{
  pageNr = pnr;
  clear();
}


void documentPage::clear()
{
#ifdef DEBUG_DOCUMENTPAGE
  kdDebug(4300) << "documentPage::clear() called for page #" << pageNumber << endl;
#endif

  sourceHyperLinkList.clear();
  textLinkList.clear();
  hyperLinkList.clear();
  
  isEmpty = true;
}

