/* 
 * Copyright (C) 2002-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: engine.h,v 1.4 2004/11/05 23:11:46 dsalt Exp $
 *
 * init xine engine, set up script engine with player object
 */

#ifndef HAVE_ENGINE_H
#define HAVE_ENGINE_H

#include <glib.h>
#include "script_engine.h"

void engine_init (void);

int engine_exec (const char *cmd, se_print_cb_t cb, void *cb_data);
int v_engine_exec (const char *cmd, se_print_cb_t cb, void *cb_data, ...);

/* non-zero on failure */
#define engine_mutex_trylock(s) \
  (!(!pthread_mutex_trylock (&engine_lock) || \
     (se->print_cb (se->print_cb_data, "sorry - engine busy."), 0)))

#endif
