/* 
 * strerror.c --
 *
 *	Source code for the "strerror" library routine.
 *
 * Copyright 1988-1991 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /usr/src/local/pmake/lib/sprite/RCS/strerror.c,v 1.2 1992/03/12 20:26:48 stolcke Exp $ SPRITE (Berkeley)";
#endif /* not lint */

#include <stdio.h>
#include "sprite.h"

extern char *sys_errlist[];
extern int sys_nerr;

/*
 *----------------------------------------------------------------------
 *
 * strerror --
 *
 *	Map an integer error number into a printable string.
 *
 * Results:
 *	The return value is a pointer to a string describing
 *	error.  The first character of string isn't capitalized.
 *
 * Side effects:
 *	Each call to this procedure may overwrite the value returned
 *	by the previous call.
 *
 *----------------------------------------------------------------------
 */

char *
strerror(error)
    int error;			/* Integer identifying error (must be
				 * one of the officially-defined Sprite
				 * errors, as defined in errno.h). */
{
    static char msg[50];

    if ((error <= sys_nerr) && (error > 0)) {
	return sys_errlist[error];
    }
    sprintf(msg, "unknown error (%d)", error);
    return msg;
}
