/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "kbabelpref.h"
#include "prefwidgets.h"
#include "kbabeldictbox.h"

#include <qlayout.h>
#include <qwhatsthis.h>
#include <qvbox.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kapplication.h>


#define PAGE_IDENTITY 0
#define PAGE_EDITOR   1
#define PAGE_SAVE     2
#define PAGE_SPELL    3
#define PAGE_SEARCH   4
#define PAGE_DIFF     5
#define PAGE_SOURCE   6
#define PAGE_MISC     7

using namespace KBabel;

KBabelPreferences::KBabelPreferences(SearchSettings searchOpts
                        , EditorSettings editOpts
			, SpellcheckSettings spellOpts
			, SaveSettings saveOpts
                        , IdentitySettings idOpts
                        , MiscSettings miscOpts, SourceContextSettings sourceOpts
			, QPtrList<ModuleInfo> ml)
    : KDialogBase(IconList, i18n("Preferences"),
                  Help|Default|Ok|Apply|Cancel, Ok,0,0,false)
{
//    setIconListAllVisible(true);

    QVBox *frame;
    frame = addVBoxPage(i18n("title of page in preferences dialog","Identity")
               , i18n("Information About You and Translation Team")
               ,UserIcon("pref_identity"));
    _identityPage = new IdentityPreferences(frame);
    _identityPage->setSettings(idOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","Edit")
            , i18n("Options for Editing"),BarIcon("edit",32));
    _editorPage = new EditorPreferences(frame);
    _editorPage->setSettings(editOpts);


    frame = addVBoxPage(i18n("title of page in preferences dialog","Save")
            , i18n("Options for File Saving"),BarIcon("filesave",32));
    _savePage = new SavePreferences(frame);
    _savePage->setSettings(saveOpts);


    frame = addVBoxPage(i18n("title of page in preferences dialog","Spelling")
            , i18n("Options for spell checking"), BarIcon("spellcheck",32));
    _spellPage = new SpellPreferences(frame);
    _spellPage->setSettings(spellOpts);


    frame = addVBoxPage(i18n("title of page in preferences dialog","Search")
            , i18n("Options for Searching Similar Translations")
                ,BarIcon("transsearch",32));
    _searchPage = new SearchPreferences(ml,frame);
    _searchPage->setSettings(searchOpts);


    frame = addVBoxPage(i18n("title of page in preferences dialog","Diff")
            , i18n("Options for Showing Differences")
                ,BarIcon("diff",32));
    _diffPage = new DiffPreferences(frame);
    _diffPage->setSettings(editOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","Source")
                ,i18n("Options for Showing Source Context"),BarIcon("source",32));
    _sourcePage = new SourceContextPreferences(frame);
    _sourcePage->setSettings(sourceOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","Miscellaneous")
                ,i18n("Miscellaneous Settings"),DesktopIcon("misc"));
    _miscPage = new MiscPreferences(frame);
    _miscPage->setSettings(miscOpts);

    adjustSize();

    _searchSettings = searchOpts;
    _editorSettings = editOpts;
    _spellcheckSettings = spellOpts;
    _saveSettings = saveOpts;
    _idSettings = idOpts;
    _miscSettings = miscOpts;
    _sourceSettings = sourceOpts;
}


void KBabelPreferences::updateIdentitySettings(IdentitySettings settings)
{
    _identityPage->setSettings(settings);
    _idSettings=settings;
}


void KBabelPreferences::updateSaveSettings(SaveSettings settings)
{
    _savePage->setSettings(settings);
    _saveSettings=settings;
}

void KBabelPreferences::updateSearchSettings(SearchSettings settings)
{
    _searchPage->setSettings(settings);
    _searchSettings = settings;
}


void KBabelPreferences::updateMiscSettings(MiscSettings settings)
{
	_miscPage->setSettings(settings);
	_miscSettings = settings;
}

void KBabelPreferences::updateSourceContextSettings(SourceContextSettings settings)
{
	_sourcePage->setSettings(settings);
	_sourceSettings = settings;
}

void KBabelPreferences::slotHelp()
{
   //TODO
   kapp->invokeHTMLHelp("Preferences","");
}

void KBabelPreferences::slotDefault()
{
   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _identityPage->defaults();
         break;
      case PAGE_SAVE:
        _savePage->defaults();
        break;
      case PAGE_EDITOR:
        _editorPage->defaults();
        break;
      case PAGE_SEARCH:
         _searchPage->defaults();
         break;
      case PAGE_MISC:
	  _miscPage->defaults();
	  break;
      case PAGE_SPELL:
         _spellPage->defaults();
         break;
      case PAGE_DIFF:
         _diffPage->defaults();
         break;
      case PAGE_SOURCE:
         _sourcePage->defaults();
         break;
      default:
        break;
   }
}

void KBabelPreferences::slotApply()
{
   QStringList list;

   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _identityPage->mergeSettings(_idSettings);
         emit identityOptionsChanged(_idSettings);
         break;
      case PAGE_SAVE:
        _savePage->mergeSettings(_saveSettings);
        emit saveOptionsChanged(_saveSettings);
        break;
      case PAGE_EDITOR:
        _editorPage->mergeSettings(_editorSettings);
        emit editorOptionsChanged(_editorSettings);
        break;
      case PAGE_SEARCH:
         _searchPage->mergeSettings(_searchSettings);
         emit searchOptionsChanged(_searchSettings);
         break;
      case PAGE_MISC:
		 _miscPage->mergeSettings(_miscSettings);
		 emit miscOptionsChanged(_miscSettings);
      case PAGE_SPELL:
         _spellPage->mergeSettings(_spellcheckSettings);
         emit spellcheckOptionsChanged(_spellcheckSettings);
         break;
      case PAGE_DIFF:
         _diffPage->mergeSettings(_editorSettings);
         emit editorOptionsChanged(_editorSettings);
         break;
      case PAGE_SOURCE:
         _sourcePage->mergeSettings(_sourceSettings);
	 emit sourceContextOptionsChanged(_sourceSettings);
         break;

      default:
        break;
   }

}

void KBabelPreferences::slotOk()
{
   _identityPage->mergeSettings(_idSettings);
   _savePage->mergeSettings(_saveSettings);
   _editorPage->mergeSettings(_editorSettings);
   _spellPage->mergeSettings(_spellcheckSettings);
   _diffPage->mergeSettings(_editorSettings);
   _searchPage->mergeSettings(_searchSettings);
   _miscPage->mergeSettings(_miscSettings);
   QStringList list;

   emit identityOptionsChanged(_idSettings);
   emit saveOptionsChanged(_saveSettings);
   emit editorOptionsChanged(_editorSettings);
   emit spellcheckOptionsChanged(_spellcheckSettings);
   emit searchOptionsChanged(_searchSettings);
   emit sourceContextOptionsChanged(_sourceSettings);
   emit miscOptionsChanged(_miscSettings);

   QDialog::accept();
}

void KBabelPreferences::slotCancel()
{
    _identityPage->setSettings(_idSettings);
    _savePage->setSettings(_saveSettings);
    _editorPage->setSettings(_editorSettings);
    _spellPage->setSettings(_spellcheckSettings);
    _diffPage->setSettings(_editorSettings);
    _searchPage->setSettings(_searchSettings);
    _miscPage->setSettings(_miscSettings);
    _sourcePage->setSettings( _sourceSettings );

    QDialog::reject();
}


#include "kbabelpref.moc"
