/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTVIEW_H
#define KMTVIEW_H

#include <qwidget.h>

class QSplitter;
class QWidgetStack;

class KHTMLPart;

class KMathToolModule;
class MessageWidget;
class ModuleTreeView;
class ModuleView;


class KMathToolView : public QWidget
{
  Q_OBJECT

  public:
    KMathToolView(QWidget* parent, const char* name = 0);

    void writeConfig( );

  public slots:
    void slotIntegrateModule(KMathToolModule* module);

  private:
    enum { INTROPART = 1, MODULES = 2 };
    void setupView( );
    void readConfig( );

  private slots:
    void slotShowView(KMathToolModule* module, ModuleView* view);
    void slotAboutToShow(QWidget* w);
    void slotShowIntroduction( );
    void slotOpenURL(const KURL& url);

  private:
    ModuleTreeView* treeView;
    MessageWidget* messages;

    QWidgetStack* mainstack;
    QWidgetStack* modstack;

    KHTMLPart* intropart;

    QSplitter* m_hsplitter;
    QSplitter* m_vsplitter;
};

#endif // KMTVIEW_H
