/***************************************************************************
                          keduca.cpp  -  description
                             -------------------
    begin                : mi may 23 20:36:15 CEST 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi@asyris.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keduca.h"
#include "keduca.moc"
#include "../libkeduca/kgallerydialog.h"
#include "keducaprefs.h"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <kedittoolbar.h>
#include <kkeydialog.h>

#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>

Keduca::Keduca( QWidget* parent, const char *name, WFlags f )
    : KMainWindow(parent, name, f),
      _mainView(0)
{
    init();
    initMenuBar();
    configRead();
}

Keduca::~Keduca()
{
    delete _recentFiles;
}

/** Init graphical interface */
void Keduca::init()
{
    QWidget *mainview = new QWidget(this);
    this->setBackgroundColor(white);
    QBoxLayout* layout_1 = new QBoxLayout( mainview, QBoxLayout::TopToBottom, 5, 5, NULL );
    layout_1->addStrut( 0 );
    QLabel *mainLabel = new QLabel(mainview, "mainLabel");
    mainLabel->setGeometry(0, 0, 256, 156);
    mainLabel->setAlignment( AlignHCenter|AlignVCenter );
    mainLabel->setPixmap( QPixmap( locate("appdata","pics/keduca_init.png") ) );
    layout_1->addWidget( mainLabel );
    mainview->show();
    this->setCentralWidget(mainview);
    this->setCaption( i18n("Main Window") );
}

/** Init menu bar settings */
void Keduca::initMenuBar()
{
    KStdAction::open(this, SLOT( slotFileOpen() ), actionCollection());
    (void)new KAction(i18n("Open Gallery..."), 0, 0, this, SLOT( slotGallery() ), actionCollection(), "open_gallery");
    _recentFiles = KStdAction::openRecent(this, SLOT ( slotFileOpenURL(const KURL &)), actionCollection());
//	KStdAction::print(this, SLOT( slotMenuPrint() ), actionCollection());
    KStdAction::close(this, SLOT( slotFileClose() ), actionCollection());
    KStdAction::quit(this, SLOT( close() ), actionCollection());

    setStandardToolBarMenuEnabled(true);
    KStdAction::keyBindings(this, SLOT( slotConfigureKeys() ), actionCollection());
    KStdAction::configureToolbars(this, SLOT( slotConfigureToolbar() ), actionCollection());
    KStdAction::preferences(this, SLOT( slotConfigure()), actionCollection());
    createGUI( "keducaui.rc" );
}

/** Open new file */
void Keduca::slotFileOpen()
{
    KURL url = KFileDialog::getOpenURL( QString::null, "application/x-edu", this,  i18n("Open Educa File") );
    if( !url.isEmpty() )
        slotFileOpenURL( url );
}

/** Open a file */
void Keduca::slotFileOpenURL( const KURL &url )
{
    _mainView = new KEducaView(this,"mainview");
    if( !_mainView->openURL(url) ) { delete _mainView; return; }
    _recentFiles->addURL( url );
    _mainView->show();
    this->setCentralWidget(_mainView);
}

/** Close actual document */
void Keduca::slotFileClose()
{
    if( _mainView ) delete _mainView;
    init();
}

/** Close the window */
bool Keduca::queryClose()
{
    configWrite();
    return( TRUE );
}

/** Read settings */
void Keduca::configRead()
{
    KConfig *config = KGlobal::config();
    config->setGroup( "keduca" );
    this->applyMainWindowSettings( config, "keduca" );
    _recentFiles->loadEntries(config);
}

/** Write settings */
void Keduca::configWrite()
{
    KConfig *config = KGlobal::config();

    config->setGroup( "keduca" );
    this->saveMainWindowSettings( config, "keduca" );
    _recentFiles->saveEntries(config);
    config->sync();
}

/** Configure keys */
void Keduca::slotConfigureKeys()
{
    KKeyDialog::configure( actionCollection() );
}

/** Configure toolbar */
void Keduca::slotConfigureToolbar()
{
    this->saveMainWindowSettings( KGlobal::config(), "keduca" );
    KEditToolbar edit( actionCollection(), "keducaui.rc", this );
    connect(&edit,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
    edit.exec();
}

/** OK/Apply pressed in toolbar editor */
void Keduca::slotNewToolbarConfig()
{
    createGUI( "keducaui.rc" );
    this->applyMainWindowSettings( KGlobal::config(), "keduca" );
}

/** Configure keduca */
void Keduca::slotConfigure()
{
    KEducaPrefs pref;
    pref.exec();
}

/** Open gallery dialog */
void Keduca::slotGallery()
{
  initGallery();
}

/** Open gallery window */
void Keduca::initGallery(const KURL &urlFile)
{
    KGalleryDialog galleries;

    if( !urlFile.url().isEmpty() )
      galleries.putURL( urlFile );

    if( galleries.exec() == QDialog::Accepted )
      slotFileOpenURL( galleries.getURL() );
}
