/*
 *  Copyright (C) 2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>
#include <kjs/interpreter.h>
#include "jsbinding.h"

#include "slotproxy.h"
#include "slotproxy.moc"

namespace KJSEmbed {

JSSlotProxy::JSSlotProxy( QObject *parent, const char *name )
    : QObject( parent, name ? name : "slot_proxy" ),
      js(0)
{
}

JSSlotProxy::~JSSlotProxy()
{
}

void JSSlotProxy::slot_void()
{
//    kdDebug(80001) << "slot_void()" << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_void() target does not support call, " << method << endl;
	return;
    }

    fun.call( js->globalExec(), obj, KJS::List() );
}

void JSSlotProxy::slot_bool( bool b )
{
//    kdDebug(80001) << "slot_bool() " << b << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_bool() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Boolean(b) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_string( const QString &s )
{
//    kdDebug(80001) << "slot_string() " << s << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_string() target does not support call, class "
		  << fun.toString(js->globalExec()).qstring() << " method " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::String(s) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_int( int i )
{
//    kdDebug(80001) << "slot_int() " << i << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_int() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Number(i) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_uint( uint i )
{
//    kdDebug(80001) << "slot_uint() " << i << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_uint() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Number(i) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_long( long i )
{
//    kdDebug(80001) << "slot_long() " << i << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_long() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Number(i) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_ulong( ulong i )
{
//   kdDebug(80001) << "slot_ulong() " << i << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_ulong() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Number(i) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_double( double d )
{
//    kdDebug(80001) << "slot_double() " << d << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_double() target does not support call, " << method << endl;
	return;
    }

    KJS::List args;
    args.append( KJS::Number(d) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_color( const QColor &color )
{
//    kdDebug(80001) << "slot_string() " << s << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_color() target does not support call, class "
		  << fun.toString(js->globalExec()).qstring() << " method " << method << endl;
	return;
    }

    KJS::List args;
    args.append( convertToValue(js->globalExec(), color) );

    fun.call( js->globalExec(), obj, args );
}

void JSSlotProxy::slot_font( const QFont &font )
{
//    kdDebug(80001) << "slot_string() " << s << endl;

    KJS::Value val = obj.get( js->globalExec(), KJS::Identifier(KJS::UString(method)) );
    KJS::Object fun = val.toObject( js->globalExec() );

    if ( !fun.implementsCall() ) {
	kdDebug(80001) << "slot_font() target does not support call, class "
		  << fun.toString(js->globalExec()).qstring() << " method " << method << endl;
	return;
    }

    KJS::List args;
   args.append( convertToValue(js->globalExec(), font) );

    fun.call( js->globalExec(), obj, args );
}
} // namespace KJSEmbed


