#!/usr/bin/env kjscmd

if ( application.args.length == 0 ) {
    throw 'Usage:\n\timagetweak imgfile ...';
}

//
// Setup main window
//
var mw = new KMainWindow();
var view = new QScrollView( mw, 'view' );
mw.setCentralWidget( view );

var lbl = new QLabel( view, 'view' );
view.addChild( lbl );

//
// Load image
//
var loc = application.args[0];
var img = new Image();

img.load( loc );
if ( !img.ok ) {
   throw 'Failed to load image ' + loc;
}

lbl.pixmap=img.pixmap;

//
// Actions
//
var ac = mw.actionCollection();

//
// Create the quit action and connect it to a C++ slot
//
StdAction.quit( application, 'quit()', ac );

//
// We'll wire the file open action up to a JS function
//

mw.openFile = function() {
   var filename = StdDialog.getOpenFileName( '.', '*' );
   if ( filename.length > 0 ) {
      view.text = System.readFile( filename );
   }
}

var open_action = StdAction.open( null, '', ac );
open_action.connect( open_action, 'activated()', mw, 'openFile' );

//
// We'll just accept the default for the rest of the actions
//

StdAction.aboutApp( null, '', ac );
StdAction.aboutKDE( null, '', ac );
StdAction.help( null, '', ac );
StdAction.helpContents( null, '', ac );
StdAction.openRecent( null, '', ac );
StdAction.save( null, '', ac );
StdAction.saveAs( null, '', ac );
StdAction.showMenubar( null, '', ac );
StdAction.showStatusbar( null, '', ac );
StdAction.showToolbar( null, '', ac );

//
// Activate XMLGUI and show the window
//
mw.createGUI( 'stdactionsui.rc' );
mw.resize( 500, 350 );
mw.show();
