/***************************************************************************
                            KShared.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHARED_H
#define KSHARED_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Reference counting for shared objects.  If you derive your object
 from this class, then you may use it in conjunction with
 @ref KSharedPtr to control the lifetime of your object.

 Specifically, all classes that derive from KShared have an internal
 counter keeping track of how many other objects have a reference to
 their object.  If used with @ref KSharedPtr, then your object will
 not be deleted until all references to the object have been
 released.

 You should probably not ever use any of the methods in this class
 directly -- let the @ref KSharedPtr take care of that.  Just derive
 your class from KShared and forget about it.

 @author Waldo Bastian <bastian@kde.org>

 @version $Id: KShared.h,v 1.3 2002/03/15 02:12:23 rdale Exp $
 
 @short 
 Reference counting for shared objects.
*/
@interface  KShared : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Standard constructor.  This will initialize the reference count
 on this object to 0
    
*/
- init;

/** 
 Copy constructor.  This will @em not actually copy the objects
 but it will initialize the reference count on this object to 0
    
*/
- copyWithZone: (NSZone *) zone;

/** 
 Increases the reference count by one
    
*/
- _KShared_ref;

/** 
 Releases a reference (decreases the reference count by one).  If
 the count goes to 0, this object will delete itself
    
*/
- _KShared_unref;

/** 
 Return the current number of references held

*/
- (int) _KShared_count;
- (void) dealloc;
@end

#endif
