/***************************************************************************
                            KServiceTypeProfile.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVICETYPEPROFILE_H
#define KSERVICETYPEPROFILE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class holds the offers for a service type
 (e.g. in old terms "the bindings for a mimetype")
 
 @short 
 This class holds the offers for a service type
 (e.
*/


@interface  KServiceTypeProfile : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- (void) dealloc;

/** 

*/
- (int) preference: (NSString *)_service;
- (BOOL) allowAsDefault: (NSString *)_service;
//- (NSArray *) offers;

/** 

 preferredService(m,true) is equivalent to preferredService(m,"Application")
 preferredService(m,false) is equivalent to preferredService(m,-[QString null])
 This call allows e.g. preferredService(m,"KParts/ReadOnlyPart").
   
*/
//+ (KService_Ptr*) preferredService: (NSString *)serviceType genericServiceType: (NSString *)genericServiceType;

/** 

*/
+ (KServiceTypeProfile*) serviceTypeProfile: (NSString *)servicetype genericServiceType: (NSString *)genericServiceType;
+ (KServiceTypeProfile*) serviceTypeProfile: (NSString *)servicetype ;

/** 

 If @p genericServiceType is specified a list is returned with 
 the offers associated with the combination of the two service types.
 This is almost like an "foo in ServiceTypes" constraint in the Trader,
 but the difference is that to order the offers, we will look at entries
 specifically for those two service types. Typically, this is used for
 getting the list of embeddable components that can handle a given mimetype.
 In that case, @p servicetype is the mimetype and @p genericServiceType is "KParts/ReadOnlyPart".
   
*/
//+ (NSArray *) offers: (NSString *)servicetype genericServiceType: (NSString *)genericServiceType;

/** 
 Clear all cached information
   
*/
+ clear;

/** 
 This method activates a special mode of KServiceTypeProfile, in which all/all
 and all/allfiles are excluded from the results of the queries.
 It is meant for the configuration module _only_. @internal.
   
*/
+ setConfigurationMode;

/**  @internal 
*/
+ (BOOL) configurationMode;

/** 
 Constructor is called when the user profile is read for the
 first time.
   
*/
- initWithText: (NSString *)_servicetype _genericServiceType: (NSString *)_genericServiceType;
- initWithText: (NSString *)_servicetype ;

/** 
 Add a service to this profile.
   
*/
- addService: (NSString *)_service _preference: (int)_preference _allow_as_default: (BOOL)_allow_as_default;
- addService: (NSString *)_service ;
@end

#endif
