/***************************************************************************
                            KRootProp.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KROOTPROP_H
#define KROOTPROP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Access KDE desktop resources stored on the root window.

 A companion to the @ref KConfig class.

 The KRootProp class is used for reading and writing configuration entries
 to properties on the root window.

 All configuration entries are of the form "key=value".

 @author Mark Donohoe (donohe@kde.org)

 @version $Id: KRootProp.h,v 1.3 2002/03/15 02:12:22 rdale Exp $

 @short 
 Access KDE desktop resources stored on the root window.
*/
@class QColor; 
@class QFont; 

@interface  KRootProp : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructs a KRootProp object for the property @p rProp.

*/
- initWithText: (NSString *)rProp;
- init;

/** 
 Destructs the KRootProp object.

 Writes back any dirty configuration entries.

*/
- (void) dealloc;

/** 
 Sets the property in which keys will be searched.

*/
- setProp: (NSString *)rProp;
- setProp;

/** 
 Returns the name of the property under which keys are searched.

*/
- (NSString *) prop;

/** 
 Destroys the property completely.

 I.e. all entries will be cleared
 and the property will be removed from the root window.

*/
- destroy;

/** 
 Reads the value of an entry specified by @p rKey in the current property.

*/
- (NSString *) readEntry: (NSString *)rKey pDefault: (NSString *)pDefault;

/** 
 Reads a numerical value.

 Reads the value of an entry specified by @p rKey in the current property
 and interprets it numerically.

*/
- (int) readNumEntry: (NSString *)rKey nDefault: (int)nDefault;
- (int) readNumEntry: (NSString *)rKey ;

/** 
 Reads a @ref QFont value.

 Reads the value of an entry specified by @p rKey in the current property
 and interpret it as a font object.

*/
- (QFont*) readFontEntry: (NSString *)rKey pDefault: (QFont *)pDefault;
- (QFont*) readFontEntry: (NSString *)rKey ;

/** 
 Reads a @ref QColor.

 Reads the value of an entry specified by @p rKey in the current property
 and interprets it as a color.

*/
- (QColor*) readColorEntry: (NSString *)rKey pDefault: (QColor*)pDefault;
- (QColor*) readColorEntry: (NSString *)rKey ;

/** 
 Writes a (key/value) pair.

 This is stored to the current property when destroying the
 config object or when calling @ref -sync.

*/
- (NSString *) writeEntry: (NSString *)rKey rValue: (NSString *)rValue;

/** 
 Writes the (key/value) pair.
 Same as above, but writes a numerical value.

*/
- (NSString *) writeEntry: (NSString *)rKey nValue: (int)nValue;

/** 
 Writes the (key/value) pair.
 Same as above, but writes a font.

*/
- (NSString *) writeEntry: (NSString *)rKey rFont: (QFont *)rFont;

/** 
 Writes the (key/value) pair.
 Same as above, but writes a color.

*/
- (NSString *) writeEntry: (NSString *)rKey rColor: (QColor *)rColor;

/** 
 Removes an entry.

*/
- (NSString *) removeEntry: (NSString *)rKey;

/** 
 Returns a list of all keys.

*/
- (NSArray *) listEntries;

/** 
 Flushes the entry cache.
 Writes back dirty configuration entries to the current property,
 This is called automatically from the destructor.

*/
- sync;
@end

#endif
