/***************************************************************************
                            KPopupMenu.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOPUPMENU_H
#define KPOPUPMENU_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QPopupMenu.h>

/**

 KPopupMenu is a class for menus with standard title items. It acts
 identically to QPopupMenu, with the addition of -insertTitle and
 -changeTitle methods.

 The titles support a text string, an icon, plus user defined gradients,
 colors, and background pixmaps.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A menu with title items.

*/
@interface KPopupMenu : QPopupMenu 

/** 
 Constructs a KPopupMenu.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Destructs the object
     
*/
- (void) dealloc;

/** 
 Inserts a title item with no icon.
     
*/
- (int) insertTitle: (NSString *)text identifier: (int)identifier index: (int)index;
- (int) insertTitle: (NSString *)text ;

/** 
 Inserts a title item with the given icon and title.
     
*/
- (int) insertTitle: (QPixmap *)icon text: (NSString *)text identifier: (int)identifier index: (int)index;
- (int) insertTitle: (QPixmap *)icon text: (NSString *)text ;

/** 
 Changes the title of the item at the specified id. If a icon was
 previously set it is cleared.
     
*/
- changeTitle: (int)identifier text: (NSString *)text;

/** 
 Changes the title and icon of the title item at the specified id.
     
*/
- changeTitle: (int)identifier icon: (QPixmap *)icon text: (NSString *)text;

/** 
 Returns the title of the title item at the specified id. The default
 id of -1 is for backwards compatibility only, you should always specify
 the id.
     
*/
- (NSString *) title: (int)identifier;

/** 
 Returns the icon of the title item at the specified id.
     
*/
- (QPixmap*) titlePixmap: (int)identifier;

/** 
 Obsolete method provided for backwards compatibility only. Use the
 normal constructor and insertTitle instead.
     
*/
- initWithText: (NSString *)title parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)title ;

/** 
 Obsolete method provided for backwards compatibility only. Use
 insertTitle and changeTitle instead.
     
*/
- setTitle: (NSString *)title;
@end

/** Override these methods in subclasses of KPopupMenu to customise event handling behaviour */
@protocol KPopupMenuEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
