/***************************************************************************
                            KPasswordEdit.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPASSWORDEDIT_H
#define KPASSWORDEDIT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QLineEdit.h>

/**


 The widget uses the user's global "echo mode" setting.
 
 @author Geert Jansen <geertj@kde.org>

 @short A safe password input widget.

*/
@interface KPasswordEdit : QLineEdit 

/** 
 Constructs a password input widget using the user's global "echo mode" setting.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a password input widget using echoMode as "echo mode".

*/
- initWithInt: (int)echoMode parent: (QWidget *)parent name: (NSString *)name;

/** 

 Creates a password input widget using echoMode as "echo mode".
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name echoMode: (int)echoMode;

/** 
 Destructs the widget.
     
*/
- (void) dealloc;

/**  
 Returns the password. The memory is freed in the destructor
 so you should make a copy.
     
*/
- (NSString *) password;

/** 
 Erases the current password.
     
*/
- erase;
- (BOOL) event: (QEvent *)e;
+ (int) OneStar;
+ (int) ThreeStars;
+ (int) NoEcho;
@end

/** Override these methods in subclasses of KPasswordEdit to customise event handling behaviour */
@protocol KPasswordEditEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) e;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
