/***************************************************************************
                            KPanelMenu.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPANELMENU_H
#define KPANELMENU_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KPopupMenu.h>

/**

 Base class to build dynamically loaded menu entries for the K-menu, or the panel.

 This class allows to build menu entries that will be dynamically added either to
 the K-menu, or to the panel as a normal button. These dynamic menus are located
 in shared libraries that will be loaded at runtime by Kicker (the KDE panel).

 To build such a menu, you have to inherit this class and implement the pure virtual
 functions @ref -initialize and @ref -slotExec. You also have to provide a factory
 object in your library, see @ref KLibFactory. This factory is only used to construct
 the menu object.

 Finally, you also have to provide a desktop file describing your dynamic menu. The
 relevant entries are: Name, Comment, Icon and X-KDE-Library (which contains the
 library name without any extension). This desktop file has to be installed in
 $KDEDIR/share/apps/kicker/menuext/.

 @author The kicker maintainer, Michael Goffioul <goffioul@imec.be>
 
 @short Base class to build dynamically loaded menu entries for the K-menu, or the panel.

*/
@interface KPanelMenu : KPopupMenu 

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Get the directory path associated with this menu, or -[QString null]if
 there's no such associated path.

*/
- (NSString *) path;

/** 
 Set a directory path to be associated with this menu.

*/
- setPath: (NSString *)p;

/** 
 Tell if the menu has been initialized, that is it already contains items.
 This is useful when you need to know if you have to clear the menu, or to
 fill it.

*/
- (BOOL) initialized;

/** 
 Set the initial state. Set it to true when you menu is filled with the items
 you want.

*/
- setInitialized: (BOOL)on;

/** 
 Reinitialize the menu: the menu is first cleared, the initial state is set
 to false, and finally @ref -initialize is called. Use this if you want to
 refill your menu.
     
*/
- reinitialize;

/** 
 Disable the automatic clearing of the menu. Kicker uses a cache system for
 its menus. After a specific configurable delay, the menu will be cleared.
 Use this function if you want to disable kicker's cache system, and avoid
 the clearing of your menu.
     
*/
- disableAutoClear;
@end

/** Override these methods in subclasses of KPanelMenu to customise event handling behaviour */
@protocol KPanelMenuEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Re-implemented for internal reasons.
     
*/
- hideEvent:(QHideEvent*) ev;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
