/***************************************************************************
                            KFileTreeBranch.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILETREEBRANCH_H
#define KFILETREEBRANCH_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDirLister.h>

/**

 This is the branch class of the KFileTreeView, which represents one
 branch in the treeview. Every branch has a root which is an url. The branch lists
 the files unter the root. Every branch uses its own dirlister and can have
 its own filter etc.

 
 @short Branch object for @ref KFileTreeView object.

*/

@class KFileTreeView;
@class KFileTreeViewItem;
@class KURL;
@class QPixmap;

@interface KFileTreeBranch : KDirLister 

/** 
 constructs a branch for KFileTreeView. Does not yet start to list it.

*/
- initWithFileTreeView: (KFileTreeView*)arg1 url: (KURL*)url name: (NSString *)name pix: (QPixmap *)pix showHidden: (BOOL)showHidden branchRoot: (KFileTreeViewItem*)branchRoot;
- initWithFileTreeView: (KFileTreeView*)arg1 url: (KURL*)url name: (NSString *)name pix: (QPixmap *)pix ;

/** 

*/
- (KURL*) rootUrl;

/** 
 sets a @ref KFileTreeViewItem as root widget for the branch.
 That must be created outside of the branch. All KFileTreeViewItems
 the branch is allocating will become children of that object.

*/
- setRoot: (KFileTreeViewItem*)r;

/** 

*/
- (KFileTreeViewItem*) root;

/** 

*/
- (NSString *) name;

/** 
 sets the name of the branch.
    
*/
- setName: (NSString *)n;
- (QPixmap*) pixmap;
- (QPixmap*) openPixmap;

/** 

*/
- (BOOL) showExtensions;

/** 
 sets the root of the branch open or closed.
    
*/
- setOpen: (BOOL)setopen;
- setOpen;

/** 
 sets if children recursion is wanted or not. If this is switched off, the
 child directories of a just opened directory are not listed internally.
 That means that it can not be determined if the sub directories are
 expandable or not. If this is switched off there will be no call to
 @ref setExpandable.

*/
- setChildRecurse: (BOOL)t;
- setChildRecurse;

/** 

*/
- (BOOL) childRecurse;

/** 
 populates a branch. This method must be called after a branch was added
 to  a @ref KFileTreeView using method @ref addBranch.

*/
- (BOOL) populate: (KURL*)url currItem: (KFileTreeViewItem*)currItem;

/** 
 sets printing of the file extensions on or off. If you pass false to this
 slot, all items of this branch will not show their file extensions in the
 tree.

*/
- setShowExtensions: (BOOL)visible;
- setShowExtensions;
- setOpenPixmap: (QPixmap *)pix;

/** 
 allocates a @ref KFileTreeViewItem for the branch
 for new items.
    
*/
- (KFileTreeViewItem*) createTreeViewItem: (KFileTreeViewItem*)parent fileItem: (KFileItem*)fileItem;

/** 
 find the according KFileTreeViewItem by an url 
    
*/
- (KFileTreeViewItem*) findTVIByURL: (KURL*)arg1;
- virtual_hook: (int)identifier data: (void*)data;
@end

#endif
