/***************************************************************************
                            KActionCollection.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KACTIONCOLLECTION_H
#define KACTIONCOLLECTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 A managed set of KAction objects.
 
 @short 
 A managed set of KAction objects.
*/

@class KAccel;
@class KConfigBase;
@class KInstance;
@class KAction;

@interface KActionCollection : QObject 
- initWithWidget: (QWidget *)parent name: (NSString *)name instance: (KInstance*)instance;
- initWithWidget: (QWidget *)parent ;

/** 
 Use this constructor if you want the collection's actions to restrict
 their accelerator keys to @p watch rather than the @p parent.  If
 you don't require shortcuts, you can pass a null to the @p watch parameter.
   
*/
- initWithWidget: (QWidget *)watch parent: (QObject *)parent name: (NSString *)name instance: (KInstance*)instance;
- initWithWidget: (QWidget *)watch parent: (QObject *)parent ;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 This sets the widget to which the keyboard shortcuts should be attached.
 You only need to call this if a null pointer was passed in the constructor.
   
*/
- setWidget: (QWidget *)widget;

/** 
 Return the collection's KAccel object
   
*/
- (KAccel*) accel;
//- (KAccel*) accel;
- (unsigned int) count;
- (BOOL) isEmpty;
- (KAction*) actionWithId: (int)index;
- (KAction*) action: (NSString *)name classname: (NSString *)classname;
- (KAction*) action: (NSString *)name ;
- (NSArray *) groups;
//- (KActionPtrList) actions: (NSString *)group;
//- (KActionPtrList) actions;

/** 
 Used for reading shortcut configuration from a non-XML rc file.
   
*/
- (BOOL) readShortcutSettings: (NSString *)sConfigGroup pConfig: (KConfigBase*)pConfig;
- (BOOL) readShortcutSettings;

/** 
 Used for writing shortcut configuration to a non-XML rc file.
   
*/
- (BOOL) writeShortcutSettings: (NSString *)sConfigGroup pConfig: (KConfigBase*)pConfig;
- (BOOL) writeShortcutSettings;
- setInstance: (KInstance*)instance;
- (KInstance*) instance;

/** 
 Use this to tell the KActionCollection what rc file its configuration
 is stored in.
   
*/
- setXMLFile: (NSString *)arg1;
- (NSString *) xmlFile;
- setHighlightingEnabled: (BOOL)enable;
- (BOOL) highlightingEnabled;
- connectHighlight: (QWidget *)container action: (KAction*)action;
- disconnectHighlight: (QWidget *)container action: (KAction*)action;
- initWithObject: (QObject *)parent name: (NSString *)name instance: (KInstance*)instance;
- initWithObject: (QObject *)parent ;
- insert: (KAction*)arg1;
- remove: (KAction*)arg1;
- (KAction*) take: (KAction*)arg1;

/** 
 Clears the entire actionCollection, deleting all actions.

*/
- clear;
- virtual_hook: (int)identifier data: (void*)data;
@end

/** Override these methods in subclasses of KActionCollection to customise event handling behaviour */
@protocol KActionCollectionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
