/***************************************************************************
                            HTMLLinkElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLLINKELEMENT_H
#define HTMLLINKELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa). See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html edef]-LINK">
 LINK element definition </a> in HTML 4.0.

 
 @short 
 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa).
*/
@class StyleSheet; 

@interface HTMLLinkElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Enables/disables the link. This is currently only used for
 style sheet links, and may be used to activate or deactivate
 style sheets.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 The character encoding of the resource being linked to. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-charset">
 charset attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) charset;

/** 
 see @ref charset
     
*/
- setCharset: (NSString *)arg1;

/** 
 The URI of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-href">
 href attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) href;

/** 
 see @ref href
     
*/
- setHref: (NSString *)arg1;

/** 
 Language code of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-hreflang">
 hreflang attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) hreflang;

/** 
 see @ref hreflang
     
*/
- setHreflang: (NSString *)arg1;

/** 
 Designed for use with one or more target media. See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.-[html adef]-media">
 media attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) media;

/** 
 see @ref media
     
*/
- setMedia: (NSString *)arg1;

/** 
 Forward link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-rel">
 rel attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) rel;

/** 
 see @ref rel
     
*/
- setRel: (NSString *)arg1;

/** 
 Reverse link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-rev">
 rev attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) rev;

/** 
 see @ref rev
     
*/
- setRev: (NSString *)arg1;

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-target">
 target attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) target;

/** 
 see @ref target
     
*/
- setTarget: (NSString *)arg1;

/** 
 Advisory content type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-type-A">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 Introduced in DOM Level 2
 This method is from the LinkStyle interface

 The style sheet.
     
*/
- (StyleSheet*) sheet;
@end

#endif
