/***************************************************************************
                            Element.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef ELEMENT_H
#define ELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DOMNode.h>

/**

 By far the vast majority of objects (apart from text) that authors
 encounter when traversing a document are <code> Element </code>
 nodes. Assume the following XML document: &lt;elementExample
 id=&quot;demo&quot;&gt; &lt;subelement1/&gt;
 &lt;subelement2&gt;&lt;subsubelement/&gt;&lt;/subelement2&gt;
 &lt;/elementExample&gt;

  When represented using DOM, the top node is an <code> Element
 </code> node for &quot;elementExample&quot;, which contains two
 child <code> Element </code> nodes, one for &quot;subelement1&quot;
 and one for &quot;subelement2&quot;. &quot;subelement1&quot;
 contains no child nodes.

  Elements may have attributes associated with them; since the
 <code> Element </code> interface inherits from <code> Node </code>
 , the generic <code> Node </code> interface method <code>
 getAttributes </code> may be used to retrieve the set of all
 attributes for an element. There are methods on the <code> Element
 </code> interface to retrieve either an <code> Attr </code> object
 by name or an attribute value by name. In XML, where an attribute
 value may contain entity references, an <code> Attr </code> object
 should be retrieved to examine the possibly fairly complex sub-tree
 representing the attribute value. On the other hand, in HTML, where
 all attributes have simple string values, methods to directly
 access an attribute value can safely be used as a convenience.

 
 @short 
 By far the vast majority of objects (apart from text) that authors
 encounter when traversing a document are <code> Element </code>
 nodes.
*/

@class Attr;
@class CSSStyleDeclaration;


@interface Element : DOMNode
- init;
- initWithDOMNode: (DOMNode*)other;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 The name of the element. For example, in: &lt;elementExample
 id=&quot;demo&quot;&gt; ... &lt;/elementExample&gt; , <code>
 tagName </code> has the value <code> &quot;elementExample&quot;
 </code> . Note that this is case-preserving in XML, as are all
 of the operations of the DOM. The HTML DOM returns the <code>
 tagName </code> of an HTML element in the canonical uppercase
 form, regardless of the case in the source HTML document.

     
*/
- (NSString *) tagName;

/** 
 Retrieves an attribute value by name.

     
*/
- (NSString *) getAttribute: (NSString *)name;

/** 
 Adds a new attribute. If an attribute with that name is already
 present in the element, its value is changed to be that of the
 value parameter. This value is a simple string, it is not
 parsed as it is being set. So any markup (such as syntax to be
 recognized as an entity reference) is treated as literal text,
 and needs to be appropriately escaped by the implementation
 when it is written out. In order to assign an attribute value
 that contains entity references, the user must create an <code>
 Attr </code> node plus any <code> Text </code> and <code>
 EntityReference </code> nodes, build the appropriate subtree,
 and use <code> setAttributeNode </code> to assign it as the
 value of an attribute.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
- setAttribute: (NSString *)name value: (NSString *)value;

/** 
 Removes an attribute by name. If the removed attribute has a
 default value it is immediately replaced.

     
*/
- removeAttribute: (NSString *)name;

/** 
 Retrieves an <code> Attr </code> node by name.

     
*/
- (Attr*) getAttributeNode: (NSString *)name;

/** 
 Adds a new attribute. If an attribute with that name is already
 present in the element, it is replaced by the new one.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

  INUSE_ATTRIBUTE_ERR: Raised if <code> newAttr </code> is
 already an attribute of another <code> Element </code> object.
 The DOM user must explicitly clone <code> Attr </code> nodes to
 re-use them in other elements.

     
*/
- (Attr*) setAttributeNode: (Attr*)newAttr;

/** 
 Removes the specified attribute.

  NOT_FOUND_ERR: Raised if <code> oldAttr </code> is not an
 attribute of the element.

     
*/
- (Attr*) removeAttributeNode: (Attr*)oldAttr;

/** 
 Returns a <code> NodeList </code> of all descendant elements
 with a given tag name, in the order in which they would be
 encountered in a preorder traversal of the <code> Element
 </code> tree.

     
*/
- (NSArray *) getElementsByTagName: (NSString *)name;

/** 
 Introduced in DOM Level 2
 Returns a NodeList of all the descendant Elements with a given local
 name and namespace URI in the order in which they are encountered in a
 preorder traversal of this Element tree.

*/
- (NSArray *) getElementsByTagNameNS: (NSString *)namespaceURI localName: (NSString *)localName;

/** 
 Introduced in DOM Level 2.

 No Exceptions.

 Retrieves an attribute value by local name and namespace URI. HTML-only
 DOM implementations do not need to implement this method.

*/
- (NSString *) getAttributeNS: (NSString *)namespaceURI localName: (NSString *)localName;

/** 
 Introduced in DOM Level 2

 Adds a new attribute. If an attribute with the same local name and
 namespace URI is already present on the element, its prefix is changed
 to be the prefix part of the qualifiedName, and its value is changed to
 be the value parameter. This value is a simple string; it is not parsed
 as it is being set. So any markup (such as syntax to be recognized as an
 entity reference) is treated as literal text, and needs to be
 appropriately escaped by the implementation when it is written out. In
 order to assign an attribute value that contains entity references, the
 user must create an Attr node plus any Text and EntityReference nodes,
 build the appropriate subtree, and use setAttributeNodeNS or
 setAttributeNode to assign it as the value of an attribute.

 HTML-only DOM implementations do not need to implement this method.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

 NAMESPACE_ERR: Raised if the qualifiedName is malformed, if the
 qualifiedName has a prefix and the namespaceURI is null, if the
 qualifiedName has a prefix that is "xml" and the namespaceURI is
 different from "http://www.w3.org/XML/1998/namespace", or if the
 qualifiedName is "xmlns" and the namespaceURI is different from
 "http://www.w3.org/2000/xmlns/".
     
*/
- setAttributeNS: (NSString *)namespaceURI qualifiedName: (NSString *)qualifiedName value: (NSString *)value;

/** 
 Introduced in DOM Level 2

 Removes an attribute by local name and namespace URI. If the removed
 attribute has a default value it is immediately replaced. The replacing
 attribute has the same namespace URI and local name, as well as the
 original prefix.

 HTML-only DOM implementations do not need to implement this method.

*/
- removeAttributeNS: (NSString *)namespaceURI localName: (NSString *)localName;

/** 
 Introduced in DOM Level 2

 Retrieves an Attr node by local name and namespace URI. HTML-only DOM
 implementations do not need to implement this method.

*/
- (Attr*) getAttributeNodeNS: (NSString *)namespaceURI localName: (NSString *)localName;

/** 
 Introduced in DOM Level 2

 Adds a new attribute. If an attribute with that local name and that
 namespace URI is already present in the element, it is replaced by the
 new one.

 HTML-only DOM implementations do not need to implement this method.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

 INUSE_ATTRIBUTE_ERR: Raised if newAttr is already an attribute of
 another Element object. The DOM user must explicitly clone Attr nodes to
 re-use them in other elements.
     
*/
- (Attr*) setAttributeNodeNS: (Attr*)newAttr;

/** 
 Returns true when an attribute with a given name is specified on this
 element or has a default value, false otherwise.
 Introduced in DOM Level 2.

*/
- (BOOL) hasAttribute: (NSString *)name;

/** 
 Introduced in DOM Level 2

 Returns true when an attribute with a given local name and namespace URI
 is specified on this element or has a default value, false otherwise.
 HTML-only DOM implementations do not need to implement this method.

*/
- (BOOL) hasAttributeNS: (NSString *)namespaceURI localName: (NSString *)localName;

/** 
 Introduced in DOM Level 2
 This method is from the CSSStyleDeclaration interface

 The style attribute
     
*/
- (CSSStyleDeclaration*) style;

/** 

 not part of the DOM
     
*/
- (BOOL) isHTMLElement;
+ (BOOL) khtmlValidAttrName: (NSString *)name;
+ (BOOL) khtmlValidPrefix: (NSString *)name;
+ (BOOL) khtmlValidQualifiedName: (NSString *)name;
+ (BOOL) khtmlMalformedQualifiedName: (NSString *)name;
+ (BOOL) khtmlMalformedPrefix: (NSString *)name;
@end

#endif
