/***************************************************************************
                            kde_KProtocolManager.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROTOCOLMANAGER
#define KDE_KPROTOCOLMANAGER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Provides information about I/O (Internet, etc.) settings chosen/set
 by the end user.

 KProtocolManager has a heap of static functions that allows only read
 access to KDE's IO related settings. These include proxy, cache, file
 transfer resumption, timeout and user-agent related settings.

 The information provided by this class is generic enough to be applicable
 to any application that makes use of KDE's IO sub-system.  Note that this
 mean the proxy, timeout etc. settings are saved in a separate user-specific
 config file and not in the config file of the application.

 @p Original author:

 @p Revised by:

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short *
 Provides information about I/O (Internet, etc.
*/
#define KPROTOCOLMANAGER_NoProxy	0
#define KPROTOCOLMANAGER_ManualProxy	1
#define KPROTOCOLMANAGER_PACProxy	2
#define KPROTOCOLMANAGER_WPADProxy	3
#define KPROTOCOLMANAGER_EnvVarProxy	4
#define KPROTOCOLMANAGER_Prompt	0
#define KPROTOCOLMANAGER_Automatic	1

/** *
 Returns the default user-agent string.

 This function returns the default user-agent string

   
*/
#ifdef __cplusplus
extern   "C" {
#endif
qt_QString * kde_KProtocolManager_defaultUserAgent( );

/** *
 Returns the default user-agent value.

 This function returns the default user-agent value
 taking into account 'keys'

 Keys can be any of the folliwing:
 'o'	Show OS
 'v'	Show OS Version
 'p'	Show platform
 'm'	Show machine architecture
 'l'	Show language

   
*/
qt_QString * kde_KProtocolManager_defaultUserAgent1( qt_QString * keys);

/** *
 Returns the userAgent string configured for the
 specified host.

 If hostname is not found or is empty (i.e. "" or
 QString::null) this function will return the default
 user agent.

*/
qt_QString * kde_KProtocolManager_userAgentForHost( qt_QString * arg1);

/** *
 Returns the preferred timeout value for reading from
 remote connections in seconds.

*/
int kde_KProtocolManager_readTimeout( );

/** *
 Returns the preferred timeout value for remote connections
 in seconds.

*/
int kde_KProtocolManager_connectTimeout( );

/** *
 Returns the preferred timeout value for proxy connections
 in seconds.

*/
int kde_KProtocolManager_proxyConnectTimeout( );

/** *
 Returns the preferred response timeout value for
 remote connecting in seconds.

*/
int kde_KProtocolManager_responseTimeout( );

/** *
 Returns the set default timeout value for connecting
 to remote machines.

*/

/** *
 Returns whether or not the user specified the
 use of proxy server to make connections.
   
*/
int kde_KProtocolManager_useProxy( );

/** *
 Returns whether or not the the proxy server
 lookup should be reversed or not.
   
*/
int kde_KProtocolManager_useReverseProxy( );

/** *
 Returns the type of proxy configuration that is used.
   
*/
int kde_KProtocolManager_proxyType( );

/** *
 Returns the way proxy authorization should be handled.

*/
int kde_KProtocolManager_proxyAuthMode( );

/** *
 Returns the strings for hosts that should contacted
 DIRECT bypassing any proxy settings.
   
*/
qt_QString * kde_KProtocolManager_noProxyFor( );
qt_QString * kde_KProtocolManager_proxyFor( qt_QString * arg1);

/** *
 Returns the Proxy server address for a given URL
 If automatic proxy configuration is configured, @ref KPAC
 is used to determine the proxy server, otherwise the return
 value of @ref #proxyFor for the URL's protocol is used.
 If an empty string is returned, the request is to be aborted,
 a return value of "DIRECT" requests a direct connection.

*/
qt_QString * kde_KProtocolManager_proxyForURL( kde_KURL* arg1);

/** *
 Marks this proxy as bad (down). It will not be used for the
 next 30 minutes. (The script may supply an alternate proxy)
   
*/
void kde_KProtocolManager_badProxy( qt_QString * arg1);

/** *

*/
qt_QString * kde_KProtocolManager_proxyConfigScript( );

/** *
 Returns true/false to indicate whether a cache
 should be used

*/
int kde_KProtocolManager_useCache( );

/** *
 Returns the maximum age in seconds cached files should be
 kept before they are deleted as necessary.

*/
int kde_KProtocolManager_maxCacheAge( );

/** *
 Returns the maximum size that can be used for caching.

 By default this function returns the DEFAULT_MAX_CACHE_SIZE
 value as defined in http_slave_defaults.h.  Not that the
 value returned is in bytes, hence a value of 5120 would mean
 5 Kb.

*/
int kde_KProtocolManager_maxCacheSize( );

/** *
 The directory which contains the cache files
   
*/
qt_QString * kde_KProtocolManager_cacheDir( );

/** *
 Returns the Cache control directive to be used.
   
*/
int kde_KProtocolManager_cacheControl( );

/** *
 Returns true if partial downloads should be
 automatically resumed.
   
*/
int kde_KProtocolManager_autoResume( );

/** *
 Returns true if partial downloads should be marked
 with a ".part" extension.
   
*/
int kde_KProtocolManager_markPartial( );

/** *
 Returns the minimum file size for keeping aborted
 downloads.

 Any data downloaded that does not meet this minimum
 requirement will simply be discarded. The default size
 is 5 KB.

 @ return the minimum keep size for aborted downloads in bytes.
   
*/
int kde_KProtocolManager_minimumKeepSize( );

/** *
 Returns true if connections should be persistent

*/
int kde_KProtocolManager_persistentProxyConnection( );

/** *
 Returns true if connections should be persistent
   
*/
int kde_KProtocolManager_persistentConnections( );

/** *
 Force a reload of the general config file of
 io-slaves ( kioslaverc).
   
*/
void kde_KProtocolManager_reparseConfiguration( );

/** *
 Return the protocol to use in order to handle the given @p url
 It's usually the same, except that FTP, when handled by a proxy,
 needs an HTTP ioslave.

 When a proxy is to be used, proxy contains the URL for the proxy.
   
*/
qt_QString * kde_KProtocolManager_slaveProtocol( kde_KURL* url, qt_QString * proxy);

/** *

 (Shared with SlaveConfig)
   
*/
kde_KConfig* kde_KProtocolManager_config( );

#ifdef __cplusplus
}
#endif
#endif
