/***************************************************************************
                            kde_KPixmap.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPIXMAP
#define KDE_KPIXMAP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Off-screen paint device with extended features.

 KPixmap has two new color modes, WebColor and LowColor, applicable
 to 8bpp displays.

 In WebColor mode all images are dithered to the Netscape palette,
 even when they have their own color table. WebColor is the default
 mode for KPixmap so that standard applications can share the Netscape
 palette across the desktop.

 In LowColor mode images are checked to see if their color table
 matches the KDE icon palette. If the color tables do not match, the
 images are dithered to a minimal 3x3x3 color cube. LowColor mode can
 be used to load icons, background images etc. so that components of
 the desktop which are always present use no more than 40 colors.

 @author Mark Donohoe (donohoe@kde.org)

 @version $Id: kde_KPixmap.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $
 
 @short *
 Off-screen paint device with extended features.
*/
#define KPIXMAP_Auto	0
#define KPIXMAP_Color	1
#define KPIXMAP_Mono	2
#define KPIXMAP_LowColor	3
#define KPIXMAP_WebColor	4
#define KPIXMAP_Horizontal	0
#define KPIXMAP_Vertical	1
#define KPIXMAP_Diagonal	2
#define KPIXMAP_CrossDiagonal	3

/** *
 Constructs a null pixmap.
	 
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KPixmap * kde_new_KPixmap();

/** *
 Destructs the pixmap.
	 
*/
void kde_del_KPixmap( kde_KPixmap* p );

/** *
 Copies the QPixmap @p pix.
         
*/
kde_KPixmap * kde_new_KPixmap1(qt_QPixmap * pix);

/** *
 Converts an image and sets this pixmap.

 The conversion_flags argument is a bitwise-OR from the
 following choices. The options marked (default) are the
 choice if no other choice from the list is included (they
 are zero):

 Color/Mono preference

 Dithering mode preference, for RGB channels

 Dithering mode preference, for alpha channel

 Color matching versus dithering preference

 Passing 0 for @p conversion_flags gives all the default
 options.

*/
int kde_KPixmap_convertFromImage(kde_KPixmap* instPointer,qt_QImage * img, int conversion_flags);

/** *
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
int kde_KPixmap_convertFromImage1(kde_KPixmap* instPointer,qt_QImage * img, int mode);

/** *
 Loads a pixmap from the file @p fileName.

 If format is specified, the loader attempts to read the
 pixmap using the specified format. If format is not
 specified (default), the loader reads a few bytes from the
 header to guess the file format.

 See the @ref convertFromImage() documentation for a description
 of the conversion_flags argument.

 The @ref QImageIO documentation lists the supported image
 formats and explains how to add extra formats.

*/
int kde_KPixmap_load(kde_KPixmap* instPointer,qt_QString * fileName, char* format, int conversion_flags);

/** *
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
int kde_KPixmap_load1(kde_KPixmap* instPointer,qt_QString * fileName, char* format, int mode);

/** *
 Returns true if the image posesses a color table that
 matches the Icon palette or false otherwise.

 An image with one color not found in the Icon palette is
 considered to be a match, since this extra color may be a
 transparent background.

*/
int kde_KPixmap_checkColorTable(kde_KPixmap* instPointer,qt_QImage * image);

#ifdef __cplusplus
}
#endif
#endif
