/***************************************************************************
                            kde_KLineEdit.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLINEEDIT
#define KDE_KLINEEDIT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 An enhanced QLineEdit widget for inputting text.

 This widget inherits from @ref QLineEdit and implements the following
 additional functionalities: a completion object that provides both
 automatic and manual text completion as well as multiple match iteration
 features, configurable key-bindings to activate these features and a
 popup-menu item that can be used to allow the user to set text completion
 modes on the fly based on their preference.

 To support these new features KLineEdit also emits a few more
 additional signals.  These are: @ref completion( const QString& ),
 textRotation( KeyBindingType ), and @ref returnPressed( const QString& ).
 The completion signal can be connected to a slot that will assist the
 user in filling out the remaining text.  The text rotation signal is
 intended to be used to iterate through the list of all possible matches
 whenever there is more than one match for the entered text.  The
 @p returnPressed( const QString& ) signals are the same as @ref QLineEdit's
 except it provides the current text in the widget as its argument whenever
 appropriate.

 This widget by default creates a completion object when you invoke
 the @ref completionObject( bool ) member function for the first time or
 use @ref setCompletionObject( KCompletion*, bool ) to assign your own
 completion object.  Additionally, to make this widget more functional,
 KLineEdit will by default handle the text rotation and completion
 events internally when a completion object is created through either one
 of the methods mentioned above.  If you do not need this functionality,
 simply use @ref KCompletionBase::setHandleSignals( bool ) or set the
 boolean parameter in the above functions to FALSE.

 The default key-bindings for completion and rotation is determined
 from the global settings in @ref KStdAccel.  These values, however,
 can be overriden locally by invoking @ref KCompletionBase::setKeyBinding().
 The values can easily be reverted back to the default setting, by simply
 calling @ref useGlobalSettings(). An alternate method would be to default
 individual key-bindings by usning @ref setKeyBinding() with the default
 second argument.

 NOTE that if the @p EchoMode for this widget is set to something other
 than @p QLineEdit::Normal, the completion mode will always be defaulted
 to @ref KGlobalSettings::CompletionNone.  This is done purposefully to guard
 against protected entries such as passwords being cached in @ref KCompletion's
 list. Hence, if the @p EchoMode is not QLineEdit::Normal, the completion
 mode is automatically disabled.

 To enable the basic completion feature :

 <pre>
 KLineEdit *edit = new KLineEdit( this, "mywidget" );
 KCompletion *comp = edit->completionObject();
 connect(edit,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 To use a customized completion objects or your
 own completion object :

 <pre>
 KLineEdit *edit = new KLineEdit( this,"mywidget" );
 KURLCompletion *comp = new KURLCompletion();
 edit->setCompletionObject( comp );
 connect(edit,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 <pre>
 edit->setHandleSignals( false );
 edit->setKeyBinding( KCompletionBase::TextCompletion, Qt::End );
 edit->setContextMenuEnabled( false );
 edit->disableSignals();
 edit->useGlobalKeyBindings();
 </pre>

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced single line input widget.

*/

/** *
 Constructs a KLineEdit object with a default text, a parent,
 and a name.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KLineEdit * kde_new_KLineEdit(qt_QString * string, qt_QWidget * parent, char* name);

/** *
 Constructs a KLineEdit object with a parent and a name.

*/
kde_KLineEdit * kde_new_KLineEdit1(qt_QWidget * parent, char* name);

/** *
  Destructor.
     
*/
void kde_del_KLineEdit( kde_KLineEdit* p );

/** *
 Sets @p url into the lineedit. It uses @ref KURL::prettyURL() so
 that the url is properly decoded for displaying.
     
*/
void kde_KLineEdit_setURL(kde_KLineEdit* instPointer,kde_KURL* url);

/** *
 Puts the text cursor at the end of the string.

 This method is deprecated.  Use @ref QLineEdit::end()
 instead.

 @ref QLineEdit::end()
     
*/
void kde_KLineEdit_cursorAtEnd(kde_KLineEdit* instPointer);

/** *
 Re-implemented from @ref KCompletionBase for internal reasons.

 This function is re-implemented in order to make sure that
 the EchoMode is acceptable before we set the completion mode.

 See @ref KCompletionBase::setCompletionMode
     
*/
void kde_KLineEdit_setCompletionMode(kde_KLineEdit* instPointer,int mode);

/** *
 Enables/disables the popup (context) menu.

 Note that when this function is invoked with its argument
 set to @p true, then both the context menu and the completion
 menu item are enabled.  If you do not want to the completion
 item to be visible simply invoke @ref hideModechanger() right
 after calling this method.  Also by default, the context
 menu is automatically created if this widget is editable. Thus
 you need to call this function with the argument set to false
 if you do not want this behaviour.

*/
void kde_KLineEdit_setContextMenuEnabled(kde_KLineEdit* instPointer,int showMenu);

/** *
 Returns @p true when the context menu is enabled.
     
*/
int kde_KLineEdit_isContextMenuEnabled(kde_KLineEdit* instPointer);

/** *
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QLineEdit is used, which inserts the encoded URL.

*/
void kde_KLineEdit_setURLDropsEnabled(kde_KLineEdit* instPointer,int enable);

/** *
 Returns @p true when decoded URL drops are enabled
     
*/
int kde_KLineEdit_isURLDropsEnabled(kde_KLineEdit* instPointer);

/** *
 By default, KLineEdit recognizes @p Key_Return and @p Key_Enter and emits
 the @ref returnPressed() signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with @p trap = @p true to make @p KLineEdit stop these
 events. The signals will still be emitted of course.

*/
void kde_KLineEdit_setTrapReturnKey(kde_KLineEdit* instPointer,int trap);

/** *

*/
int kde_KLineEdit_trapReturnKey(kde_KLineEdit* instPointer);

/** *

*/
kde_KCompletionBox* kde_KLineEdit_completionBox(kde_KLineEdit* instPointer,int create);

/** *
 Reimplemented for internal reasons, the API is not affected.
     
*/
void kde_KLineEdit_setCompletionObject(kde_KLineEdit* instPointer,kde_KCompletion* arg1, int hsig);

/** *
 Reimplemented for internal reasons, the API is not affected.
     
*/
void kde_KLineEdit_copy(kde_KLineEdit* instPointer);

/** *
 Re-implemented for internal reasons. API not changed.
     
*/
void kde_KLineEdit_setReadOnly(kde_KLineEdit* instPointer,int arg1);

/** *
 Iterates through all possible matches of the completed text or
 the history list.

 This function simply iterates over all possible matches in case
 multimple matches are found as a result of a text completion request.
 It will have no effect if only a single match is found.

*/
void kde_KLineEdit_rotateText(kde_KLineEdit* instPointer,int arg1);

/** *
 See @ref KCompletionBase::setCompletedText.
     
*/
void kde_KLineEdit_setCompletedText(kde_KLineEdit* instPointer,qt_QString * arg1);

/** *
 Sets @p items into the completion-box if @ref completionMode() is
 CompletionPopup. The popup will be shown immediately.
     
*/
void kde_KLineEdit_setCompletedItems(kde_KLineEdit* instPointer,qt_QStringList* items);

/** *
 Reimplemented to workaround a buggy QLineEdit::clear()
 (changing the clipboard to the text we just had in the lineedit)
     
*/
void kde_KLineEdit_clear(kde_KLineEdit* instPointer);

/** *
 Squeezes @p text into the line edit. 
 This can only be used with read-only line-edits.

*/
void kde_KLineEdit_setSqueezedText(kde_KLineEdit* instPointer,qt_QString * text);

/** *
 Re-implemented for internal reasons.  API not affected.

 See @ref QLineEdit::resizeEvent().
    
*/

/** *
 Re-implemented for internal reasons.  API not affected.

 See @ref QLineEdit::keyPressEvent().
    
*/

/** *
 Re-implemented for internal reasons.  API not affected.

 See @ref QLineEdit::mousePressEvent().
    
*/

/** *
 Re-implemented for internal reasons.  API not affected.

 See @ref QWidget::mouseDoubleClickEvent().
    
*/

/** *
 Re-implemented for internal reasons.  API not affected.

 See @ref QLineEdit::createPopupMenu().
    
*/
qt_QPopupMenu* kde_KLineEdit_createPopupMenu(kde_KLineEdit* instPointer);

/** *
 Re-implemented to handle URI drops.

 See @ref QLineEdit::dropEvent().
    
*/
void kde_KLineEdit_setCompletedText1(kde_KLineEdit* instPointer,qt_QString * arg1, int arg2);

/** *
 Reimplemented for internal reasons, the API is not affected.
     
*/
void kde_KLineEdit_create(kde_KLineEdit* instPointer,unsigned int arg1, int initializeWindow, int destroyOldWindow);
void kde_KLineEdit_virtual_hook(kde_KLineEdit* instPointer,int identifier, void* data);

/** *
 Completes the remaining text with a matching one from
 a given list.
    
*/
void kde_KLineEdit_makeCompletion(kde_KLineEdit* instPointer,qt_QString * arg1);

/** *

     
*/
void kde_KLineEdit_slotAboutToShow(kde_KLineEdit* instPointer);

/** *

     
*/
void kde_KLineEdit_slotCancelled(kde_KLineEdit* instPointer);

/** Casts a 'kde_KLineEdit *' to a 'kde_KCompletionBase*' */
kde_KCompletionBase* kde_KLineEdit_KCompletionBase(kde_KLineEdit* instPointer);

/** Casts a 'kde_KLineEdit *' to a 'qt_QLineEdit*' */
qt_QLineEdit* kde_KLineEdit_QLineEdit(kde_KLineEdit* instPointer);

#ifdef __cplusplus
}
#endif
#endif
