/***************************************************************************
                            kde_KDockMainWindow.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDOCKMAINWINDOW
#define KDE_KDOCKMAINWINDOW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A special kind of @ref KMainWindow that is able to have dockwidget child widgets (and member of the dockwidget class set).

 The main widget should be a @ref KDockWidget where other @ref KDockWidget can be docked to
 the left, right, top, bottom or to the middle.
 Note: dock to the middle means to drop on a dockwidget and to unite them to a new widget, a tab control.

 Furthermore, the KDockMainWindow has got the @ref KDockManager and some data about the dock states.

 If you've got some dockwidgets, you can dock them to the dockmainwindow to initialize a start scene:
 Here an example:
 <PRE>
 DockApplication::DockApplication( const char* name) : KDockMainWindow( name)
 {
   ...
   KDockWidget* mainDock;
   mainDock = createDockWidget( "Falk's MainDockWidget", mainPixmap, 0L, "main_dock_widget");
   AnyContentsWidget* cw = new AnyContentsWidget( mainDock);
   mainDock->setWidget( cw);
   mainDock->setDockSite(KDockWidget::DockCorner);
   mainDock->setEnableDocking(KDockWidget::DockNone);
   setView( mainDock); // central widget in a KDE mainwindow
   setMainDockWidget( mainDock); // master dockwidget
   ...
   KDockWidget* dockLeft;
   dockLeft = createDockWidget( "Intially left one", anyOtherPixmap, 0L, i18n("The left dockwidget"));
   AnotherWidget* aw = new AnotherWidget( dockLeft);
   dockLeft->setWidget( aw);
   dockLeft->manualDock( mainDock,              // dock target
                         KDockWidget::DockLeft, // dock site
                         20 );                  // relation target/this (in percent)
   ...
 </PRE>

 Docking is fully dynamical at runtime. That means you can always move dockwidgets via drag and drop.

 And last but not least you can use the popupmenu for showing or hiding any controlled dockwidget
 of this class and insert it to your main menu bar or anywhere else.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short *
 A special kind of @ref KMainWindow that is able to have dockwidget child widgets (and member of the dockwidget class set).
*/

/** *
 Constructs a dockmainwindow. It calls its base class constructor and does additional things concerning
 to the dock stuff:

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDockMainWindow * kde_new_KDockMainWindow(qt_QWidget * parent, char* name, int f);

/** *
 Destructs a dockmainwindow.
   
*/
void kde_del_KDockMainWindow( kde_KDockMainWindow* p );

/** *
 Returns the dockmanager of this. (see @ref KDockManager)

*/
kde_KDockManager* kde_KDockMainWindow_manager(kde_KDockMainWindow* instPointer);

/** *
 Sets a new main dockwidget.
 Additionally, the toolbar is re-initialized.

*/
void kde_KDockMainWindow_setMainDockWidget(kde_KDockMainWindow* instPointer,kde_KDockWidget* arg1);

/** *
 Returns the main dockwidget.

*/
kde_KDockWidget* kde_KDockMainWindow_getMainDockWidget(kde_KDockMainWindow* instPointer);

/** *
 This is one of the most important methods!
 The KDockMainWindow creates a new dockwidget object here that usually should encapsulate the user's widget.
 The new dockwidget is automatically taken under control by the dockmanager of the dockmainwindow.

*/
kde_KDockWidget* kde_KDockMainWindow_createDockWidget(kde_KDockMainWindow* instPointer,qt_QString * name, qt_QPixmap * pixmap, qt_QWidget * parent, qt_QString * strCaption, qt_QString * strTabPageLabel);

/** *
 Saves the current dock window layout into a DOM tree below the given element.
   
*/
void kde_KDockMainWindow_writeDockConfig(kde_KDockMainWindow* instPointer,qt_QDomElement* base);

/** *
 Reads the current dock window layout from a DOM tree below the given element.
   
*/
void kde_KDockMainWindow_readDockConfig(kde_KDockMainWindow* instPointer,qt_QDomElement* base);

/** *
 It writes the current dock state in the given section of KConfig.

*/
void kde_KDockMainWindow_writeDockConfig1(kde_KDockMainWindow* instPointer,kde_KConfig* c, qt_QString * group);

/** *
 It reads the current dock state from the given section of KConfig.

*/
void kde_KDockMainWindow_readDockConfig1(kde_KDockMainWindow* instPointer,kde_KConfig* c, qt_QString * group);

/** *
 It runs through all dockwidgets which are under control of the dockmanager and calls show() for every
 encapsulated widget and show() for the dockwidget itself if it is not in tab mode.
 Additionally, if the main dockwidget is not a QDialog, it will be shown.
   
*/
void kde_KDockMainWindow_activateDock(kde_KDockMainWindow* instPointer);

/** *
 Returns a popup menu that contains entries for all controlled dockwidgets making hiding and showing
 them possible.

*/
qt_QPopupMenu* kde_KDockMainWindow_dockHideShowMenu(kde_KDockMainWindow* instPointer);

/** *
 This method shows the given dockwidget.
 The clue is that it also considers the dockwidget could be a tab page
 and must set to be the activate one.

*/
void kde_KDockMainWindow_makeDockVisible(kde_KDockMainWindow* instPointer,kde_KDockWidget* dock);

/** *
 This method hides the given dockwidget.

*/
void kde_KDockMainWindow_makeDockInvisible(kde_KDockMainWindow* instPointer,kde_KDockWidget* dock);

/** *
 This is an overloaded member function, provided for convenience.
 It differs from the above function only in what argument(s) it accepts.
   
*/
void kde_KDockMainWindow_makeWidgetDockVisible(kde_KDockMainWindow* instPointer,qt_QWidget * widget);

/** *
 This method calls the base class method.
 If the given widget inherits KDockWidget, applyToWidget(this) is called.

*/
void kde_KDockMainWindow_setView(kde_KDockMainWindow* instPointer,qt_QWidget * arg1);
void kde_KDockMainWindow_virtual_hook(kde_KDockMainWindow* instPointer,int identifier, void* data);

/** *
 Called whenever one of the dockwidgets of this has been undocked.
  
*/
void kde_KDockMainWindow_slotDockWidgetUndocked(kde_KDockMainWindow* instPointer);

#ifdef __cplusplus
}
#endif
#endif
