/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __kicker_h__
#define __kicker_h__

#include <kuniqueapplication.h>

class PanelKMenu;
class KGlobalAccel;
class PanelPopupButton;

class Kicker : public KUniqueApplication
{
    Q_OBJECT
    K_DCOP

public:
    Kicker();
    ~Kicker();

k_dcop:
    void configure();
    void restart();
    void addExtension( const QString &desktopFile );
    void popupKMenu( const QPoint &globalPos );
    void clearQuickStartMenu();
    void configLaunched();
    bool highlightMenuItem( const QString &menuId );
    void showKMenu();

public:
    static Kicker* kicker();

    bool isImmutable() const;
    PanelKMenu* KMenu() { return kMenu; }

    PanelPopupButton* KButton() { return kButton; }
    void setKButton(PanelPopupButton *button) { kButton = button; }

    static QStringList configModules(bool controlCenter);

public slots:
    void slotLaunchConfig();
    void slotLaunchConfig(const QString& configPath);

signals:
    void configurationChanged();

private slots:
    void slotSettingsChanged( int );
    void slotKMenuAccel();
    void slotDesktopAccel();
    void slotRestart();
    void slotSetKMenuItemActive();
    void slotDesktopResized();

private:
    PanelKMenu*    kMenu;
    KGlobalAccel*  keys;
    QString        m_panelConfiged;
    PanelPopupButton* kButton;
};

#endif
