/******************************************************************************
 *
 * 
 *
 * Copyright (C) 1997-2004 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */
 
 /*
  * Original Hungarian translation by
  * Gyrgy Fldvri  <foldvari@diatronltd.com>
  *
  * Extended, revised and updated by
  * kos Kiss  <akiss@users.sourceforge.net>
  *
  * Further extended, revised and updated by
  * Tamsi Ferenc <tf551@hszk.bme.hu>
  */

#ifndef TRANSLATOR_HU_H
#define TRANSLATOR_HU_H

#include "translator.h"
#include "../qtools/qdatetime.h"

class TranslatorHungarian : public Translator
{
  private:
    const char * zed(char c)
    {
        switch (c & ~('a' ^ 'A')) {
            case 'B': case 'C': case 'D': case 'F': case 'G':
            case 'H': case 'J': case 'K': case 'L': case 'M':
            case 'N': case 'P': case 'Q': case 'R': case 'S':
            case 'T': case 'V': case 'W': case 'X': case 'Z':
                return "  ";
            default:
                return "z ";
        }
    }
  public:

    // --- Language control methods -------------------
    QCString idLanguage()
    { return "hungarian"; }
    /*! Used to get the command(s) for the language support. This method
     *  was designed for languages which do not prefer babel package.
     *  If this methods returns empty string, then the latexBabelPackage()
     *  method is used to generate the command for using the babel package.
     */
    QCString latexLanguageSupportCommand()
    {
      return "";
    }

    /*! return the language charset. This will be used for the HTML output */
    QCString idLanguageCharset()
    {
      return "iso-8859-2";
    }

    // --- Language translation methods -------------------

    /*! used in the compound documentation before a list of related functions. */
    QCString trRelatedFunctions()
    { return "Kapcsold fggvnyek"; }

    /*! subscript for the related functions. */
    QCString trRelatedSubscript()
    { return "(Figyelem! Ezek a fggvnyek nem tagjai az osztlynak!)"; }

    /*! header that is put before the detailed description of files, classes and namespaces. */
    QCString trDetailedDescription()
    { return "Rszletes lers"; }

    /*! header that is put before the list of typedefs. */
    QCString trMemberTypedefDocumentation()
    { return "Tpusdefinci-tagok dokumentcija"; }
    
    /*! header that is put before the list of enumerations. */
    QCString trMemberEnumerationDocumentation()
    { return "Enumerci-tagok dokumentcija"; }
    
    /*! header that is put before the list of member functions. */
    QCString trMemberFunctionDocumentation()
    { return "Tagfggvnyek dokumentcija"; }
    
    /*! header that is put before the list of member attributes. */
    QCString trMemberDataDocumentation()
    {
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatmezk dokumentcija"; 
      }
      else
      {
        return "Adattagok dokumentcija"; 
      }
    }

    /*! this is the text of a link put after brief descriptions. */
    QCString trMore() 
    { return "Rszletek..."; }

    /*! put in the class documentation */
    QCString trListOfAllMembers()
    { return "A tagok teljes listja."; }

    /*! used as the title of the "list of all members" page of a class */
    QCString trMemberList()
    { return "Taglista"; }

    /*! this is the first part of a sentence that is followed by a class name */
    QCString trThisIsTheListOfAllMembers()
    { return "A(z) "; }

    /*! this is the remainder of the sentence after the class name */
    QCString trIncludingInheritedMembers()
    { return " osztly tagjainak teljes listja, az rklt tagokkal egytt."; }
    
    QCString trGeneratedAutomatically(const char *s)
    { QCString result="Ezt a dokumentcit a Doxygen ksztette ";
      if (s) result+=(QCString)" a" + zed(s[0])+s+(QCString)" projekthez";
      result+=" a forrskdbl."; 
      return result;
    }

    /*! put after an enum name in the list of all members */
    QCString trEnumName()
    { return "enum"; }
    
    /*! put after an enum value in the list of all members */
    QCString trEnumValue()
    { return "enum-rtk"; }
    
    /*! put after an undocumented member in the list of all members */
    QCString trDefinedIn()
    { return "definilja:"; }

    // quick reference sections

    /*! This is put above each page as a link to the list of all groups of 
     *  compounds or files (see the \\group command).
     */
    QCString trModules()
    { return "Modulok"; }
    
    /*! This is put above each page as a link to the class hierarchy */
    QCString trClassHierarchy()
    { return "Osztlyhierarchia"; }
    
    /*! This is put above each page as a link to the list of annotated classes */
    QCString trCompoundList()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatszerkezetek";
      }
      else
      {
        return "Osztlylista"; 
      }
    }
    
    /*! This is put above each page as a link to the list of documented files */
    QCString trFileList()
    { return "Fjllista"; }

    /*! This is put above each page as a link to the list of all verbatim headers */
    QCString trHeaderFiles()
    { return "Defincis fjlok"; }

    /*! This is put above each page as a link to all members of compounds. */
    QCString trCompoundMembers()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatmezk"; 
      }
      else
      {
        return "Osztlytagok"; 
      }
    }

    /*! This is put above each page as a link to all members of files. */
    QCString trFileMembers()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Globlis elemek"; 
      }
      else
      {
        return "Fjlelemek"; 
      }
    }

    /*! This is put above each page as a link to all related pages. */
    QCString trRelatedPages()
    { return "Kapcsold lapok"; }

    /*! This is put above each page as a link to all examples. */
    QCString trExamples()
    { return "Pldk"; }

    /*! This is put above each page as a link to the search engine. */
    QCString trSearch()
    { return "Keress"; }

    /*! This is an introduction to the class hierarchy. */
    QCString trClassHierarchyDescription()
    { return "Majdnem (de nem teljesen) betrendbe szedett "
             "leszrmazsi lista:";
    }

    /*! This is an introduction to the list with all files. */
    QCString trFileListDescription(bool extractAll)
    {
      QCString result="Az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="fjl listja rvid lersokkal:";
      return result;
    }

    /*! This is an introduction to the annotated compound list. */
    QCString trCompoundListDescription()
    { 
      
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Az sszes adatszerkezet listja rvid lersokkal:"; 
      }
      else
      {
        return "Az sszes osztly, struktra, uni s interfsz "
               "listja rvid lersokkal:"; 
      }
    }

    /*! This is an introduction to the page with all class members. */
    QCString trCompoundMembersDescription(bool extractAll)
    {
      QCString result="Az sszes ";
      if (!extractAll)
      {
        result+="dokumentlt ";
      }
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        result+="struktra- s nimez";
      }
      else
      {
        result+="osztlytag";
      }
      result+=" listja, valamint hivatkozs ";
      if (!extractAll) 
      {
        if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
        {
          result+="a megfelel struktra-/nidokumentcira minden meznl:";
        }
        else
        {
          result+="a megfelel osztlydokumentcira minden tagnl:";
        }
      }
      else 
      {
        if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
        {
          result+="a struktrkra/nikra, amikhez tartoznak:";
        }
        else
        {
          result+="az osztlyokra, amikhez tartoznak:";
        }
      }
      return result;
    }

    /*! This is an introduction to the page with all file members. */
    QCString trFileMembersDescription(bool extractAll)
    {
      QCString result="Az sszes ";
      if (!extractAll) result+="dokumentlt ";
      
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        result+="fggvny, vltoz, makrdefinci, enumerci s tpusdefinci";
      }
      else
      {
        result+="fjlelem";
      }
      result+=" listja, valamint hivatkozs ";
      if (extractAll) 
        result+="a fjlokra, amikhez tartoznak:";
      else 
        result+="a dokumentcira:";
      return result;
    }

    /*! This is an introduction to the page with the list of all header files. */
    QCString trHeaderFilesDescription()
    { return "A Programozi Interfszt (API) alkot defincis fjlok listja:"; }

    /*! This is an introduction to the page with the list of all examples */
    QCString trExamplesDescription()
    { return "A pldk listja:"; }

    /*! This is an introduction to the page with the list of related pages */
    QCString trRelatedPagesDescription()
    { return "A kapcsold dokumentcik listja:"; }

    /*! This is an introduction to the page with the list of class/file groups */
    QCString trModulesDescription()
    { return "A modulok listja:"; }

    /*! This sentences is used in the annotated class/file lists if no brief
     * description is given. 
     */
    QCString trNoDescriptionAvailable()
    { return "Nincs lers"; }
    
    // index titles (the project name is prepended for these) 


    /*! This is used in HTML as the title of index.html. */
    QCString trDocumentation()
    { return "Dokumentci"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * index of all groups.
     */
    QCString trModuleIndex()
    { return "Modulmutat"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * class hierarchy.
     */
    QCString trHierarchicalIndex()
    { return "Hierarchikus mutat"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * annotated compound index.
     */
    QCString trCompoundIndex()
    {
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      { 
        return "Adatszerkezet-mutat";
      }
      else
      {
        return "Osztlymutat"; 
      }
    }

    /*! This is used in LaTeX as the title of the chapter with the
     * list of all files.
     */
    QCString trFileIndex() 
    { return "Fjlmutat"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all groups.
     */
    QCString trModuleDocumentation()
    { return "Modulok dokumentcija"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all classes, structs and unions.
     */
    QCString trClassDocumentation()
    { return "Osztlyok dokumentcija"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all files.
     */
    QCString trFileDocumentation()
    { return "Fjlok dokumentcija"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all examples.
     */
    QCString trExampleDocumentation()
    { return "Pldk dokumentcija"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all related pages.
     */
    QCString trPageDocumentation()
    { return "Kapcsold dokumentcik"; }

    /*! This is used in LaTeX as the title of the document */
    QCString trReferenceManual()
    { return "Referencia kziknyv"; }
    
    /*! This is used in the documentation of a file as a header before the 
     *  list of defines
     */
    QCString trDefines()
    { return "Makrdefincik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of function prototypes
     */
    QCString trFuncProtos()
    { return "Fggvny-prototpusok"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of typedefs
     */
    QCString trTypedefs()
    { return "Tpusdefincik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of enumerations
     */
    QCString trEnumerations()
    { return "Enumercik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) functions
     */
    QCString trFunctions()
    { return "Fggvnyek"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trVariables()
    { return "Vltozk"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trEnumerationValues()
    { return "Enumerci-rtkek"; }
    
    /*! This is used in the documentation of a file before the list of
     *  documentation blocks for defines
     */
    QCString trDefineDocumentation()
    { return "Makrdefincik dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for function prototypes
     */
    QCString trFunctionPrototypeDocumentation()
    { return "Fggvny-prototpusok dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for typedefs
     */
    QCString trTypedefDocumentation()
    { return "Tpusdefincik dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration types
     */
    QCString trEnumerationTypeDocumentation()
    { return "Enumercik dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration values
     */
    QCString trEnumerationValueDocumentation()
    { return "Enumerci-rtkek dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for functions
     */
    QCString trFunctionDocumentation()
    { return "Fggvnyek dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for variables
     */
    QCString trVariableDocumentation()
    { return "Vltozk dokumentcija"; }

    /*! This is used in the documentation of a file/namespace/group before 
     *  the list of links to documented compounds
     */
    QCString trCompounds()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatszerkezetek"; 
      }
      else
      {
        return "Osztlyok"; 
      }
    }

    /*! This is used in the standard footer of each page and indicates when 
     *  the page was generated 
     */
    QCString trGeneratedAt(const char *date,const char *projName)
    { 
      QCString result=(QCString)"";
      if (projName) result+=(QCString)"Projekt: "+projName;
      result+=(QCString)" Kszlt: "+date+" Ksztette: ";
      return result;
    }
    /*! This is part of the sentence used in the standard footer of each page.
     */
    QCString trWrittenBy()
    {
      return " melyet rt ";
    }

    /*! this text is put before a class diagram */
    QCString trClassDiagram(const char *clName)
    {
      return (QCString)"A"+zed(clName[0])+clName+" osztly szrmazsi diagramja:";
    }
    
    /*! this text is generated when the \\internal command is used. */
    QCString trForInternalUseOnly()
    { return "CSAK BELS HASZNLATRA!"; }

    /*! this text is generated when the \\reimp command is used. */
    QCString trReimplementedForInternalReasons()
    { return "Bels okok miatt jraimplementlva; az API-t nem rinti."; }

    /*! this text is generated when the \\warning command is used. */
    QCString trWarning()
    { return "Figyelmeztets"; }

    /*! this text is generated when the \\bug command is used. */
    QCString trBugsAndLimitations()
    { return "Hibk s korltozsok"; }

    /*! this text is generated when the \\version command is used. */
    QCString trVersion()
    { return "Verzi"; }

    /*! this text is generated when the \\date command is used. */
    QCString trDate()
    { return "Dtum"; }

    /*! this text is generated when the \\return command is used. */
    QCString trReturns()
    { return "Visszatrsi rtk"; }

    /*! this text is generated when the \\sa command is used. */
    QCString trSeeAlso()
    { return "Lsd mg"; }

    /*! this text is generated when the \\param command is used. */
    QCString trParameters()
    { return "Paramterek"; }

    /*! this text is generated when the \\exception command is used. */
    QCString trExceptions()
    { return "Kivtelek"; }
    
    /*! this text is used in the title page of a LaTeX document. */
    QCString trGeneratedBy()
    { return "Ksztette"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990307
//////////////////////////////////////////////////////////////////////////
    
    /*! used as the title of page containing all the index of all namespaces. */
    QCString trNamespaceList()
    { return "Nvtrlista"; }

    /*! used as an introduction to the namespace list */
    QCString trNamespaceListDescription(bool extractAll)
    {
      QCString result="Az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="nvtr listja rvid lersokkal:";
      return result;
    }

    /*! used in the class documentation as a header before the list of all
     *  friends of a class
     */
    QCString trFriends()
    { return "Bartok"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990405
//////////////////////////////////////////////////////////////////////////
    
    /*! used in the class documentation as a header before the list of all
     * related classes 
     */
    QCString trRelatedFunctionDocumentation()
    { return "Bart s kapcsold fggvnyek dokumentcija"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990425
//////////////////////////////////////////////////////////////////////////

    /*! used as the title of the HTML page of a class/struct/union */
    QCString trCompoundReference(const char *clName,
                                    ClassDef::CompoundType compType,
                                    bool isTemplate)
    {
      QCString result=(QCString)clName;
      switch(compType)
      {
        case ClassDef::Class:      result+=" osztly"; break;
        case ClassDef::Struct:     result+=" struktra"; break;
        case ClassDef::Union:      result+=" uni"; break;
        case ClassDef::Interface:  result+=" interfsz"; break;
        case ClassDef::Protocol:   result+=" protocol"; break; // translate me!
        case ClassDef::Category:   result+=" category"; break; // translate me!
        case ClassDef::Exception:  result+=" kivtel"; break;
      }
      if (isTemplate) result+="sablon-";
      result+="referencia";
      return result;
    }

    /*! used as the title of the HTML page of a file */
    QCString trFileReference(const char *fileName)
    {
      QCString result=fileName;
      result+=" fjlreferencia"; 
      return result;
    }

    /*! used as the title of the HTML page of a namespace */
    QCString trNamespaceReference(const char *namespaceName)
    {
      QCString result=namespaceName;
      result+=" nvtr-referencia";
      return result;
    }
    
    QCString trPublicMembers()
    { return "Publikus tagfggvnyek"; }
    QCString trPublicSlots()
    { return "Publikus rsek"; }
    QCString trSignals()
    { return "Szignlok"; }
    QCString trStaticPublicMembers()
    { return "Statikus publikus tagfggvnyek"; }
    QCString trProtectedMembers()
    { return "Vdett tagfggvnyek"; }
    QCString trProtectedSlots()
    { return "Vdett rsek"; }
    QCString trStaticProtectedMembers()
    { return "Statikus vdett tagfggvnyek"; }
    QCString trPrivateMembers()
    { return "Privt tagfggvnyek"; }
    QCString trPrivateSlots()
    { return "Privt rsek"; }
    QCString trStaticPrivateMembers()
    { return "Statikus privt tagfggvnyek"; }
    
    /*! this function is used to produce a comma-separated list of items.
     *  use generateMarker(i) to indicate where item i should be put.
     */
    QCString trWriteList(int numEntries)
    {
      QCString result;
      int i;
      // the inherits list contain `numEntries' classes
      for (i=0;i<numEntries;i++) 
      {
        // use generateMarker to generate placeholders for the class links!
        result+=generateMarker(i); // generate marker for entry i in the list 
                                   // (order is left to right)
        
        if (i!=numEntries-1)  // not the last entry, so we need a separator
        {
          if (i<numEntries-2) // not the fore last entry 
            result+=", ";
          else                // the fore last entry
            result+=" s ";
        }
      }
      return result; 
    }
    
    /*! used in class documentation to produce a list of base classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritsList(int numEntries)
    {
      return "sk: "+trWriteList(numEntries)+".";
    }

    /*! used in class documentation to produce a list of super classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritedByList(int numEntries)
    {
      return "Leszrmazottak: "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of 
     *  members that are hidden by this one.
     */
    QCString trReimplementedFromList(int numEntries)
    {
      return "jraimplementlt sk: "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of
     *  all member that overwrite the implementation of this member.
     */
    QCString trReimplementedInList(int numEntries)
    {
      return "jraimplementl leszrmazottak: "+trWriteList(numEntries)+".";
    }

    /*! This is put above each page as a link to all members of namespaces. */
    QCString trNamespaceMembers()
    { return "Nvtrtagok"; }

    /*! This is an introduction to the page with all namespace members */
    QCString trNamespaceMemberDescription(bool extractAll)
    { 
      QCString result="Az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="nvtr tagjainak listja, valamint hivatkozs ";
      if (extractAll) 
        result+=" a megfelel nvtr dokumentcira minden tagnl:";
      else 
        result+=" a nvterekre, amelynek tagjai:";
      return result;
    }
    /*! This is used in LaTeX as the title of the chapter with the 
     *  index of all namespaces.
     */
    QCString trNamespaceIndex()
    { return "Nvtrmutat"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all namespaces.
     */
    QCString trNamespaceDocumentation()
    { return "Nvterek dokumentcija"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990522
//////////////////////////////////////////////////////////////////////////

    /*! This is used in the documentation before the list of all
     *  namespaces in a file.
     */
    QCString trNamespaces()
    { return "Nvterek"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990728
//////////////////////////////////////////////////////////////////////////

    /*! This is put at the bottom of a class documentation page and is
     *  followed by a list of files that were used to generate the page.
     */
    QCString trGeneratedFromFiles(ClassDef::CompoundType compType,
        bool single)
    { // here s is one of " Class", " Struct" or " Union"
      // single is true implies a single file
      QCString result=(QCString)"Ez a dokumentci ";
      switch(compType)
      {
        case ClassDef::Class:      result+="az osztlyrl"; break;
        case ClassDef::Struct:     result+="a struktrrl"; break;
        case ClassDef::Union:      result+="az unirl"; break;
        case ClassDef::Interface:  result+="az interfszrl"; break;
        case ClassDef::Protocol:   result+="protocol"; break; // translate me!
        case ClassDef::Category:   result+="category"; break; // translate me!
        case ClassDef::Exception:  result+="a kivtelrl"; break;
      }
      result+=" a kvetkez fjl";
      if (!single) result+="ok";
      result+=" alapjn kszlt:";
      return result;
    }

    /*! This is in the (quick) index as a link to the alphabetical compound
     * list.
     */
    QCString trAlphabeticalList()
    { return "Betrendes lista"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990901
//////////////////////////////////////////////////////////////////////////

    /*! This is used as the heading text for the retval command. */
    QCString trReturnValues()
    { return "Visszatrsi rtkek"; }

    /*! This is in the (quick) index as a link to the main page (index.html)
     */
    QCString trMainPage()
    { return "Foldal"; }

    /*! This is used in references to page that are put in the LaTeX 
     *  documentation. It should be an abbreviation of the word page.
     */
    QCString trPageAbbreviation()
    { return "o."; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991003
//////////////////////////////////////////////////////////////////////////

    QCString trSources()
    {
      return "Forrsok";
    }
    QCString trDefinedAtLineInSourceFile()
    {
      return "Definci a(z) @1 fjl @0. sorban.";
    }
    QCString trDefinedInSourceFile()
    {
      return "Definci a(z) @0 fjlban.";
    }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991205
//////////////////////////////////////////////////////////////////////////

    QCString trDeprecated()
    {
      return "Ellenjavallt";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.0.0
//////////////////////////////////////////////////////////////////////////

    /*! this text is put before a collaboration diagram */
    QCString trCollaborationDiagram(const char *clName)
    {
      return (QCString)"A"+zed(clName[0])+clName+" osztly egyttmkdsi diagramja:";
    }
    /*! this text is put before an include dependency graph */
    QCString trInclDepGraph(const char *fName)
    {
      return (QCString)"A"+zed(fName[0])+fName+" defincis fjl fggsi grfja:";
    }
    /*! header that is put before the list of constructor/destructors. */
    QCString trConstructorDocumentation()
    {
      return "Konstruktorok s destruktorok dokumentcija"; 
    }
    /*! Used in the file documentation to point to the corresponding sources. */
    QCString trGotoSourceCode()
    {
      return "Ugrs a fjl forrskdjhoz.";
    }
    /*! Used in the file sources to point to the corresponding documentation. */
    QCString trGotoDocumentation()
    {
      return "Ugrs a fjl dokumentcijhoz.";
    }
    /*! Text for the \\pre command */
    QCString trPrecondition()
    {
      return "Elfelttel";
    }
    /*! Text for the \\post command */
    QCString trPostcondition()
    {
      return "Utfelttel";
    }
    /*! Text for the \\invariant command */
    QCString trInvariant()
    {
      return "Invarins";
    }
    /*! Text shown before a multi-line variable/enum initialization */
    QCString trInitialValue()
    {
      return "Kezd rtk:";
    }
    /*! Text used the source code in the file index */
    QCString trCode()
    {
      return "forrskd";
    }
    QCString trGraphicalHierarchy()
    {
      return "Osztlyhierarchia-bra";
    }
    QCString trGotoGraphicalHierarchy()
    {
      return "Ugrs az osztlyhierarchia-brhoz";
    }
    QCString trGotoTextualHierarchy()
    {
      return "Ugrs az szveges osztlyhierarchihoz";
    }
    QCString trPageIndex()
    {
      return "Oldalmutat";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.0
//////////////////////////////////////////////////////////////////////////
    
    QCString trNote()
    {
      return "Megjegyzs";
    }
    QCString trPublicTypes()
    {
      return "Publikus tpusok";
    }
    QCString trPublicAttribs()
    {
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatmezk";
      }
      else
      {
        return "Publikus attribtumok";
      }
    }
    QCString trStaticPublicAttribs()
    {
      return "Statikus publikus attribtumok";
    }
    QCString trProtectedTypes()
    {
      return "Vdett tpusok";
    }
    QCString trProtectedAttribs()
    {
      return "Vdett attribtumok";
    }
    QCString trStaticProtectedAttribs()
    {
      return "Statikus vdett attribtumok";
    }
    QCString trPrivateTypes()
    {
      return "Privt tpusok";
    }
    QCString trPrivateAttribs()
    {
      return "Privt attribtumok";
    }
    QCString trStaticPrivateAttribs()
    {
      return "Statikus privt attribtumok";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.3
//////////////////////////////////////////////////////////////////////////

    /*! Used as a marker that is put before a todo item */
    QCString trTodo()
    {
      return "Tennival";
    }
    /*! Used as the header of the todo list */
    QCString trTodoList()
    {
      return "Tennivalk listja";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.4
//////////////////////////////////////////////////////////////////////////

    QCString trReferencedBy()
    {
      return "Hivatkozsok:";
    }
    QCString trRemarks()
    {
      return "Megjegyzsek";
    }
    QCString trAttention()
    {
      return "Figyelem";
    }
    QCString trInclByDepGraph()
    {
      return "Ez az bra azt mutatja, hogy mely fjlok gyazzk be "
             "kzvetve vagy kzvetlenl ezt a fjlt:";
    }
    QCString trSince()
    {
      return "Elszr bevezetve";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.1.5
//////////////////////////////////////////////////////////////////////////

    /*! title of the graph legend page */
    QCString trLegendTitle()
    {
      return "Jelmagyarzat";
    }
    /*! page explaining how the dot graph's should be interpreted */
    QCString trLegendDocs()
    {
      return 
        "Ez az oldal elmagyarzza hogyan kell rtelmezni a "
        "doxygen ltal ksztett brkat.<p>\n"
        "Vegyk a kvetkez pldt:\n"
        "\\code\n"
        "/*! Vgs miatt nem lthat osztly */\n"
        "class Invisible { };\n\n"
        "/*! Levgott osztly, szrmazsa rejtett */\n"
        "class Truncated : public Invisible { };\n\n"
        "/* Doxygen kommentekkel nem dokumentlt osztly */\n"
        "class Undocumented { };\n\n"
        "/*! Publikus szrmaztatsal levezetett osztly */\n"
        "class PublicBase : public Truncated { };\n\n"
        "/*! Egy sablonosztly */\n"
        "template<class T> class Templ { };\n\n"
        "/*! Vdett szrmaztatsal levezetett osztly */\n"
        "class ProtectedBase { };\n\n"
        "/*! Privt szrmaztatsal levezetett osztly */\n"
        "class PrivateBase { };\n\n"
        "/*! Osztly, melyet a szrmaztatott osztly hasznl */\n"
        "class Used { };\n\n"
        "/*! Osztly, mely tbb msiknak leszrmazottja */\n"
        "class Inherited : public PublicBase,\n"
        "                  protected ProtectedBase,\n"
        "                  private PrivateBase,\n"
        "                  public Undocumented\n"
        "                  public Templ<int>\n"
        "{\n"
        "  private:\n"
        "    Used *m_usedClass;\n"
        "};\n"
        "\\endcode\n"
        "Ha a konfigurcis fjl \\c MAX_DOT_GRAPH_HEIGHT elemnek rtkt "
        "240-re lltjuk, az eredmny a kvetkez bra lesz:"
        "<p><center><img src=\"graph_legend."+Config_getEnum("DOT_IMAGE_FORMAT")+"\"></center>\n"
        "<p>\n"
        "Az brn lev dobozok jelentse:\n"
        "<ul>\n"
        "<li>Kitlttt fekete doboz jelzi azt az osztlyt vagy struktrt,"
        "amelyrl az bra szl.\n"
        "<li>Fekete keret jelzi a dokumentlt osztlyokat s struktrkat.\n"
        "<li>Szrke keret jelzi a nem dokumentlt osztlyokat s struktrkat.\n"
        "<li>Piros keret jelzi azokat az osztlyokat s struktrkat, amelyeknl vgs miatt nem lthat "
        "az sszes leszrmaztatsi kapcsolat. Egy bra vgsra kerl, ha nem fr bele "
        "a megadott tartomnyba."
        "</ul>\n"
        "A nyilak jelentse:\n"
        "<ul>\n"
        "<li>Sttkk nyl jelzi a publikus szrmaztatst.\n"
        "<li>Sttzld nyl jelzi a vdett szrmaztatst.\n"
        "<li>Sttvrs nyl jelzi a privt szrmaztatst.\n"
        "<li>Lila szaggatott nyl jelzi, ha az osztly egy msikat hasznl vagy tartalmaz. "
        "A nyl felirata jelzi a vltoz(k) nevt, amelyeken keresztl a msik osztly kapcsoldik.\n"
        "<li>Srga szaggatott nyl jelzi a kapcsolatot a sablonpldny s a pldnyostott "
        "osztlysablon kztt. A nyl felirata jelzi a plny sablonparamtereit.\n"
        "</ul>\n";

    }
    /*! text for the link to the legend page */
    QCString trLegend()
    {
      return "Jelmagyarzat";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.2.0
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a test item */
    QCString trTest()
    {
      return "Teszt";
    }
    /*! Used as the header of the test list */
    QCString trTestList()
    {
      return "Tesztlista";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.1
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for KDE-2 IDL methods */
    virtual QCString trDCOPMethods()
    {
      return "DCOP tagfggvnyek";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.2
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for IDL properties */
    virtual QCString trProperties()
    {
      return "Tulajdonsgok";
    }
    /*! Used as a section header for IDL property documentation */
    virtual QCString trPropertyDocumentation()
    {
      return "Tulajdonsgok dokumentcijka";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.4
//////////////////////////////////////////////////////////////////////////

    /*! Used for Java interfaces in the summary section of Java packages */
    virtual QCString trInterfaces()
    {
      return "Interfszek";
    }
    /*! Used for Java classes in the summary section of Java packages */
    virtual QCString trClasses()
    {
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return "Adatszerkezetek";
      }
      else
      {
        return "Osztlyok";
      }
    }
    /*! Used as the title of a Java package */
    virtual QCString trPackage(const char *name)
    {
      return name+(QCString)" csomag";
    }
    /*! Title of the package index page */
    virtual QCString trPackageList()
    {
      return "Csomaglista";
    }
    /*! The description of the package index page */
    virtual QCString trPackageListDescription()
    {
      return "A csomagok rvid lersai (amennyiben lteznek):";
    }
    /*! The link name in the Quick links header for each page */
    virtual QCString trPackages()
    {
      return "Csomagok";
    }
    /*! Used as a chapter title for Latex & RTF output */
    virtual QCString trPackageDocumentation()
    {
      return "Csomagok dokumentcija";
    }
    /*! Text shown before a multi-line define */
    virtual QCString trDefineValue()
    {
      return "rtk:";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.2.5
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a \\bug item */
    virtual QCString trBug()
    {
      return "Hiba";
    }
    /*! Used as the header of the bug list */
    virtual QCString trBugList()
    {
      return "Hiba lista";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.6
//////////////////////////////////////////////////////////////////////////

    /*! Used as ansicpg for RTF file 
     * 
     * The following table shows the correlation of Charset name, Charset Value and 
     * <pre>
     * Codepage number:
     * Charset Name       Charset Value(hex)  Codepage number
     * ------------------------------------------------------
     * DEFAULT_CHARSET           1 (x01)
     * SYMBOL_CHARSET            2 (x02)
     * OEM_CHARSET             255 (xFF)
     * ANSI_CHARSET              0 (x00)            1252
     * RUSSIAN_CHARSET         204 (xCC)            1251
     * EE_CHARSET              238 (xEE)            1250
     * GREEK_CHARSET           161 (xA1)            1253
     * TURKISH_CHARSET         162 (xA2)            1254
     * BALTIC_CHARSET          186 (xBA)            1257
     * HEBREW_CHARSET          177 (xB1)            1255
     * ARABIC _CHARSET         178 (xB2)            1256
     * SHIFTJIS_CHARSET        128 (x80)             932
     * HANGEUL_CHARSET         129 (x81)             949
     * GB2313_CHARSET          134 (x86)             936
     * CHINESEBIG5_CHARSET     136 (x88)             950
     * </pre>
     * 
     */
    virtual QCString trRTFansicp()
    {
      return "1252";
    }
    

    /*! Used as ansicpg for RTF fcharset 
     *  \see trRTFansicp() for a table of possible values.
     */
    virtual QCString trRTFCharSet()
    {
      return "0";
    }

    /*! Used as header RTF general index */
    virtual QCString trRTFGeneralIndex()
    {
      return "Trgymutat";
    }
   
    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trClass(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Osztly" : "osztly"));
      //if (!singular)  result+="es";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trFile(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Fjl" : "fjl"));
      //if (!singular)  result+="s";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trNamespace(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Nvtr" : "nvtr"));
      //if (!singular)  result+="s";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trGroup(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Csoport" : "csoport"));
      //if (!singular)  result+="s";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trPage(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Oldal" : "oldal"));
      //if (!singular)  result+="s";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trMember(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Tag" : "tag"));
      //if (!singular)  result+="s";
      return result; 
    }
   
    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trField(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Mez" : "mez"));
      //if (!singular)  result+="s";
      return result; 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trGlobal(bool first_capital, bool /*singular*/)
    { 
      QCString result((first_capital ? "Globlis elem" : "globlis elem"));
      //if (!singular)  result+="s";
      return result; 
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.7
//////////////////////////////////////////////////////////////////////////

    /*! This text is generated when the \\author command is used and
     *  for the author section in man pages. */
    virtual QCString trAuthor(bool first_capital, bool singular)
    {                                                                         
      QCString result((first_capital ? "Szerz" : "szerz"));
      if (!singular)  result+="k";
      return result; 
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.11
//////////////////////////////////////////////////////////////////////////

    /*! This text is put before the list of members referenced by a member
     */
    virtual QCString trReferences()
    {
      return "Hivatkozsok";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.13
//////////////////////////////////////////////////////////////////////////

    /*! used in member documentation blocks to produce a list of 
     *  members that are implemented by this one.
     */
    virtual QCString trImplementedFromList(int numEntries)
    {
      return "Megvalstja a kvetkezket: "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of
     *  all members that implement this abstract member.
     */
    virtual QCString trImplementedInList(int numEntries)
    {
      return "Megvalstjk a kvetkezk: "+trWriteList(numEntries)+".";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.16
//////////////////////////////////////////////////////////////////////////

    /*! used in RTF documentation as a heading for the Table
     *  of Contents.
     */
    virtual QCString trRTFTableOfContents()
    {
      return "Tartalomjegyzk";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.17
//////////////////////////////////////////////////////////////////////////

    /*! Used as the header of the list of item that have been 
     *  flagged deprecated 
     */
    virtual QCString trDeprecatedList()
    {
      return "Ellenjavallt elemek listja";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.18
//////////////////////////////////////////////////////////////////////////

    /*! Used as a header for declaration section of the events found in 
     * a C# program
     */
    virtual QCString trEvents()
    {
      return "Esemnyek";
    }
    /*! Header used for the documentation section of a class' events. */
    virtual QCString trEventDocumentation()
    {
      return "Esemnyek dokumentcija";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.3
//////////////////////////////////////////////////////////////////////////

    /*! Used as a heading for a list of Java class types with package scope.
     */
    virtual QCString trPackageTypes()
    { 
      return "Csomag tpusok";
    }
    /*! Used as a heading for a list of Java class functions with package 
     * scope. 
     */
    virtual QCString trPackageMembers()
    { 
      return "Csomag fggvnyek";
    }
    /*! Used as a heading for a list of static Java class functions with 
     *  package scope.
     */
    virtual QCString trStaticPackageMembers()
    { 
      return "Statikus csomag fggvnyek";
    }
    /*! Used as a heading for a list of Java class variables with package 
     * scope.
     */
    virtual QCString trPackageAttribs()
    { 
      return "Csomag attribtumok";
    }
    /*! Used as a heading for a list of static Java class variables with 
     * package scope.
     */
    virtual QCString trStaticPackageAttribs()
    { 
      return "Statikus csomag attribtumok";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.3.1
//////////////////////////////////////////////////////////////////////////

    /*! Used in the quick index of a class/file/namespace member list page 
     *  to link to the unfiltered list of all members.
     */
    virtual QCString trAll()
    {
      return "sszes";
    }
    /*! Put in front of the call graph for a function. */
    virtual QCString trCallGraph()
    {
      return "A fggvny hvsi grfja:";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.3.3
//////////////////////////////////////////////////////////////////////////

    /*! When the search engine is enabled this text is put in the header 
     *  of each page before the field where one can enter the text to search 
     *  for. 
     */
    virtual QCString trSearchForIndex()
    {
      return "Keressi kulcs";
    }
    /*! This string is used as the title for the page listing the search
     *  results.
     */
    virtual QCString trSearchResultsTitle()
    {
      return "A keress eredmnye";
    }
    /*! This string is put just before listing the search results. The
     *  text can be different depending on the number of documents found.
     *  Inside the text you can put the special marker $num to insert
     *  the number representing the actual number of search results.
     *  The @a numDocuments parameter can be either 0, 1 or 2, where the 
     *  value 2 represents 2 or more matches. HTML markup is allowed inside
     *  the returned string.
     */
    virtual QCString trSearchResults(int numDocuments)
    {
      if (numDocuments==0)
      {
        return "Sajnos egy dokumentum sem felelt meg a keressi feltteleknek.";
      }
      else if (numDocuments==1)
      {
        return "<b>1</b> dokumentum felelt meg a keressi feltteleknek.";
      }
      else 
      {
        return "<b>$num</b> dokumentum felelt meg a keressi feltteleknek."
               "Elsnek a legjobb tallatok vannak feltntetve.";
      }
    }
    /*! This string is put before the list of matched words, for each search 
     *  result. What follows is the list of words that matched the query.
     */
    virtual QCString trSearchMatches()
    {
      return "Tallatok:";
    }

};

#endif
