/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.manager.forms.RegexGroup;
import com.paterva.maltego.entity.manager.forms.RegexGroupsTableModel;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.ListUtil;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.util.NbBundle;

public class AdvancedSettingsControl
extends JPanel {
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private RegexGroupsTableModel _tableModel;
    private DisplayDescriptorCollection _properties;
    private JButton _addButton;
    private JSpinner _conversionOrder;
    private JPanel _conversionPanel;
    private JButton _downButton;
    private JTextField _plural;
    private JTextField _regex;
    private JCheckBox _regexCheckBox;
    private JCheckBox _root;
    private ETable _table;
    private JButton _upButton;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane4;

    public AdvancedSettingsControl() {
        this.initComponents();
        this.setName("Advanced Settings");
        this._tableModel = new RegexGroupsTableModel();
        this._table.setModel((TableModel)((Object)this._tableModel));
        EditableTableDecorator decorator = new EditableTableDecorator();
        decorator.addDelete((JTable)this._table, true, true);
        PaddedTableCellRenderer renderer = new PaddedTableCellRenderer();
        this._table.setDefaultRenderer(Integer.class, (TableCellRenderer)renderer);
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this._table.setAutoCreateColumnsFromModel(false);
        this._table.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        TableColumnModel columnModel = this._table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(0).setMaxWidth(50);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(1).setCellEditor(new PropertyComboCellEditor());
        this._tableModel.addTableModelListener(new MappingTableModelListener());
        this._regex.getDocument().addDocumentListener((DocumentListener)this._changeSupport);
    }

    public String getRegex() {
        return this._regex.getText().trim();
    }

    public String getPluralName() {
        return this._plural.getText();
    }

    public boolean getIsRoot() {
        return this._root.isSelected();
    }

    public int getConversionOrder() {
        return (Integer)this._conversionOrder.getValue();
    }

    public void setIsRoot(boolean value) {
        this._root.setSelected(value);
    }

    public void setRegex(String value) {
        this._regex.setText(value);
        this._regexCheckBox.setSelected(!StringUtilities.isNullOrEmpty((String)value));
        this.updateStates();
    }

    public void setRegexGroups(List<String> groupProperties) {
        ArrayList<RegexGroup> groups = new ArrayList<RegexGroup>();
        for (String property : groupProperties) {
            groups.add(new RegexGroup(this._properties.get(property)));
        }
        this._tableModel.setRows(groups);
    }

    public List<String> getRegexGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        List regexGroups = this._tableModel.getRows();
        for (RegexGroup regexGroup : regexGroups) {
            DisplayDescriptor property = regexGroup.getProperty();
            groups.add(property != null ? property.getName() : "");
        }
        return groups;
    }

    public void setProperties(DisplayDescriptorCollection properties) {
        this._properties = properties;
    }

    private void populateCombo(JComboBox comboBox, DisplayDescriptor current) {
        comboBox.removeAllItems();
        comboBox.addItem("<Ignore>");
        List rows = this._tableModel.getRows();
        for (DisplayDescriptor dd : this._properties) {
            boolean add;
            if (dd.equals((PropertyDescriptor)current)) {
                add = true;
            } else {
                add = true;
                for (RegexGroup group : rows) {
                    if (!dd.equals((PropertyDescriptor)group.getProperty())) continue;
                    add = false;
                    break;
                }
            }
            if (!add) continue;
            comboBox.addItem(dd);
        }
    }

    public boolean hasRegex() {
        return this._regexCheckBox.isSelected() && !this.getRegex().isEmpty();
    }

    public void setPluralName(String value) {
        this._plural.setText(value);
    }

    public void setConversionOrder(int i) {
        this._conversionOrder.setValue(i);
    }

    private void updateStates() {
        boolean regexEnabled = this._regexCheckBox.isSelected();
        this._regex.setEnabled(regexEnabled);
        this._conversionOrder.setEnabled(regexEnabled);
        this._table.setEnabled(regexEnabled);
        this._addButton.setEnabled(regexEnabled);
        this._upButton.setEnabled(regexEnabled);
        this._downButton.setEnabled(regexEnabled);
    }

    private void onSelectedGroupsChanged() {
        boolean canDown;
        boolean canUp;
        if (this._table.getSelectionModel().getValueIsAdjusting()) {
            return;
        }
        int selectedRowCount = this._table.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int row = this._table.convertRowIndexToModel(this._table.getSelectedRow());
            canUp = row != 0;
            canDown = row != this._tableModel.getRowCount() - 1;
        } else {
            canDown = canUp = selectedRowCount > 0;
        }
        this._upButton.setEnabled(canUp);
        this._downButton.setEnabled(canDown);
    }

    private List<RegexGroup> getSelectedGroups() {
        int[] selectedRows;
        ArrayList<RegexGroup> selected = new ArrayList<RegexGroup>();
        for (int row : selectedRows = this._table.getSelectedRows()) {
            selected.add((RegexGroup)this._tableModel.getRow(this._table.convertRowIndexToModel(row)));
        }
        return selected;
    }

    private void setSelection(List<RegexGroup> selected) {
        ListSelectionModel selectionModel = this._table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            if (!selected.contains(this._tableModel.getRow(i))) continue;
            int row = this._table.convertRowIndexToView(i);
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        LabelWithBackground jLabel1 = new LabelWithBackground();
        this._plural = new JTextField();
        LabelWithBackground jLabel2 = new LabelWithBackground();
        this._root = new JCheckBox();
        this._conversionPanel = new JPanel();
        LabelWithBackground jLabel3 = new LabelWithBackground();
        this._regex = new JTextField();
        LabelWithBackground jLabel7 = new LabelWithBackground();
        this._conversionOrder = new JSpinner();
        this._regexCheckBox = new JCheckBox();
        LabelWithBackground jLabel4 = new LabelWithBackground();
        this.jScrollPane4 = new JScrollPane();
        this._table = new ETable();
        this.jLabel5 = new LabelWithBackground();
        this._addButton = new JButton();
        this._upButton = new JButton();
        this._downButton = new JButton();
        this.jLabel6 = new JLabel();
        this.setPreferredSize(new Dimension(561, 396));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jPanel1.border.title")));
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel1.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel1.add((Component)jLabel1, gridBagConstraints);
        this._plural.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._plural.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 300;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.jPanel1.add((Component)this._plural, gridBagConstraints);
        jLabel2.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel1.add((Component)jLabel2, gridBagConstraints);
        this._root.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._root.text"));
        this._root.setHorizontalAlignment(11);
        this._root.setPreferredSize(new Dimension(26, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.jPanel1.add((Component)this._root, gridBagConstraints);
        this._conversionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._conversionPanel.border.border.title"))));
        this._conversionPanel.setMinimumSize(new Dimension(540, 214));
        this._conversionPanel.setPreferredSize(new Dimension(540, 434));
        this._conversionPanel.setLayout(new GridBagLayout());
        jLabel3.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this._conversionPanel.add((Component)jLabel3, gridBagConstraints);
        this._regex.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._regex.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this._conversionPanel.add((Component)this._regex, gridBagConstraints);
        jLabel7.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this._conversionPanel.add((Component)jLabel7, gridBagConstraints);
        this._conversionOrder.setModel(new SpinnerNumberModel((Number)1000, Integer.valueOf(1), null, (Number)1));
        this._conversionOrder.setEditor(new JSpinner.NumberEditor(this._conversionOrder, "#"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this._conversionPanel.add((Component)this._conversionOrder, gridBagConstraints);
        this._regexCheckBox.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._regexCheckBox.text"));
        this._regexCheckBox.setHorizontalAlignment(11);
        this._regexCheckBox.setMaximumSize(new Dimension(26, 21));
        this._regexCheckBox.setMinimumSize(new Dimension(26, 21));
        this._regexCheckBox.setPreferredSize(new Dimension(26, 21));
        this._regexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSettingsControl.this._regexCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this._conversionPanel.add((Component)this._regexCheckBox, gridBagConstraints);
        jLabel4.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this._conversionPanel.add((Component)jLabel4, gridBagConstraints);
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._table.setFillsViewportHeight(true);
        this._table.setPreferredScrollableViewportSize(new Dimension(250, 300));
        this.jScrollPane4.setViewportView((Component)this._table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this._conversionPanel.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jLabel5.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this._conversionPanel.add((Component)this.jLabel5, gridBagConstraints);
        this._addButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/entity/manager/resources/Add.png")));
        this._addButton.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._addButton.text"));
        this._addButton.setToolTipText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._addButton.toolTipText"));
        this._addButton.setFocusPainted(false);
        this._addButton.setMaximumSize(new Dimension(30, 25));
        this._addButton.setMinimumSize(new Dimension(30, 25));
        this._addButton.setPreferredSize(new Dimension(30, 25));
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSettingsControl.this._addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this._conversionPanel.add((Component)this._addButton, gridBagConstraints);
        this._upButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/entity/manager/resources/Up.png")));
        this._upButton.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._upButton.text"));
        this._upButton.setToolTipText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl._upButton.toolTipText"));
        this._upButton.setFocusPainted(false);
        this._upButton.setMaximumSize(new Dimension(30, 25));
        this._upButton.setMinimumSize(new Dimension(30, 25));
        this._upButton.setPreferredSize(new Dimension(30, 25));
        this._upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSettingsControl.this._upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this._conversionPanel.add((Component)this._upButton, gridBagConstraints);
        this._downButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/entity/manager/resources/Down.png")));
        this._downButton.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.text"));
        this._downButton.setToolTipText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.toolTipText"));
        this._downButton.setFocusPainted(false);
        this._downButton.setMaximumSize(new Dimension(30, 25));
        this._downButton.setMinimumSize(new Dimension(30, 25));
        this._downButton.setName("");
        this._downButton.setPreferredSize(new Dimension(30, 25));
        this._downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSettingsControl.this._downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this._conversionPanel.add((Component)this._downButton, gridBagConstraints);
        this.jLabel6.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-description-foreground"));
        this.jLabel6.setText(NbBundle.getMessage(AdvancedSettingsControl.class, (String)"AdvancedSettingsControl.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 30, 6, 6);
        this._conversionPanel.add((Component)this.jLabel6, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this._conversionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._conversionPanel, -1, 280, Short.MAX_VALUE).addContainerGap()));
    }

    private void _addButtonActionPerformed(ActionEvent evt) {
        this._tableModel.addRow(new RegexGroup(null));
    }

    private void _regexCheckBoxActionPerformed(ActionEvent evt) {
        this.updateStates();
    }

    private void _upButtonActionPerformed(ActionEvent evt) {
        List bindings = this._tableModel.getRows();
        List<RegexGroup> selectedBindings = this.getSelectedGroups();
        ListUtil.moveSelectedUp((List)bindings, selectedBindings);
        this._tableModel.fireTableDataChanged();
        this.setSelection(selectedBindings);
    }

    private void _downButtonActionPerformed(ActionEvent evt) {
        List bindings = this._tableModel.getRows();
        List<RegexGroup> selectedBindings = this.getSelectedGroups();
        ListUtil.moveSelectedDown((List)bindings, selectedBindings);
        this._tableModel.fireTableDataChanged();
        this.setSelection(selectedBindings);
    }

    private class MappingTableModelListener
    implements TableModelListener {
        private MappingTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (AdvancedSettingsControl.this._properties != null) {
                AdvancedSettingsControl.this.onSelectedGroupsChanged();
            }
        }
    }

    private class PropertyComboCellEditor
    extends DefaultCellEditor {
        public PropertyComboCellEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                DisplayDescriptor current = value instanceof DisplayDescriptor ? (DisplayDescriptor)value : null;
                AdvancedSettingsControl.this.populateCombo(comboBox, current);
                if (current != null) {
                    comboBox.setSelectedItem(current);
                }
            }
            return component;
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AdvancedSettingsControl.this.onSelectedGroupsChanged();
        }
    }
}

