/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.util;

import com.paterva.maltego.util.ui.button.ButtonPainter;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.color.ColorUtil;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;

public class CommandButtonPainter {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private AbstractCommandButton commandButton;
    private boolean isRollover = false;
    private boolean isPressed = false;
    private boolean isSelected = false;
    private boolean isPopupRollover = false;
    private boolean isActionEnabled = false;
    private boolean isPopupEnabled = false;
    private boolean isPopupOnly = false;
    private boolean isInStrip = false;
    private boolean isFirstInStrip = false;
    private boolean isLastInStrip = false;
    private boolean isStripVertical = false;
    private boolean ignorePressed = false;
    private BufferedImage highlightImage;
    Object oldAa;

    public CommandButtonPainter(AbstractCommandButton commandButton) {
        this(commandButton, false);
    }

    public CommandButtonPainter(AbstractCommandButton commandButton, boolean ignorePressed) {
        this.commandButton = commandButton;
        this.ignorePressed = ignorePressed;
    }

    protected void updateState() {
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        PopupButtonModel popupModel = null;
        if (this.commandButton instanceof JCommandButton) {
            JCommandButton jcb = (JCommandButton)this.commandButton;
            popupModel = jcb.getPopupModel();
            this.isPopupOnly = jcb.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY;
        }
        this.isActionEnabled = actionModel != null && actionModel.isEnabled();
        this.isPopupEnabled = popupModel != null && popupModel.isEnabled();
        this.isPressed = !this.ignorePressed && actionModel != null && actionModel.isPressed() || popupModel != null && popupModel.isPressed();
        this.isSelected = actionModel != null && actionModel.isSelected() || popupModel != null && popupModel.isSelected();
        this.isRollover = actionModel != null && actionModel.isRollover() || popupModel != null && (popupModel.isRollover() || popupModel.isPopupShowing());
        boolean bl = this.isPopupRollover = popupModel != null && popupModel.isRollover();
        if (this.commandButton.getParent() instanceof JCommandButtonStrip) {
            JCommandButtonStrip strip = (JCommandButtonStrip)this.commandButton.getParent();
            this.isInStrip = true;
            this.isFirstInStrip = strip.isFirst(this.commandButton);
            this.isLastInStrip = strip.isLast(this.commandButton);
            this.isStripVertical = strip.getOrientation() == JCommandButtonStrip.StripOrientation.VERTICAL;
        }
    }

    public void paintBackground(Graphics g, Rectangle toFill) {
        Graphics2D g2d = (Graphics2D)g.create();
        int x = toFill.x;
        int y = toFill.y;
        int width = toFill.width;
        int height = toFill.height;
        this.updateState();
        if (this.isPressed) {
            this.paintPressedBackground(g2d, x, y, width, height);
        } else if (this.isSelected) {
            this.paintSelectedBackground(g2d, toFill.x, toFill.y, toFill.width, toFill.height);
        } else if (this.isRollover) {
            this.paintRolloverBackground(g2d, x, y, width, height);
        } else if (!this.commandButton.isFlat()) {
            this.paintNormalBackground(g2d, x, y, width, height);
        }
        g2d.dispose();
    }

    protected void paintNormalBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintNormalBackground((Graphics2D)g2d, (int)x, (int)y, (int)width, (int)height, (boolean)this.isInStrip, (boolean)this.isStripVertical, (boolean)this.isFirstInStrip, (boolean)this.isLastInStrip);
    }

    protected void paintSelectedBackground(Graphics2D g, int x, int y, int width, int height) {
        CommandButtonDisplayState state = this.commandButton.getDisplayState();
        if (state == CommandButtonDisplayState.BIG) {
            if (!this.isSplit()) {
                this.paintBigSelectedBackground(g, x, y, width, height);
            } else {
                Rectangle actionRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
                Rectangle popupRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
                g.setClip(actionRect);
                this.paintBigSelectedBackground(g, x, y, width, height);
                g.setClip(popupRect);
                if (this.isRollover && !this.isPopupRollover) {
                    ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)true, (boolean)this.isPopupEnabled);
                } else if (this.isPopupRollover) {
                    ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)false, (boolean)this.isPopupEnabled);
                } else {
                    this.paintBigSelectedBackground(g, x, y, width, height);
                }
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(g, x, y, width, height);
            }
            if (!this.isSplit()) {
                this.paintSmallSelectedBackground(g, x, y, width, height);
            } else {
                Rectangle actionRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
                Rectangle popupRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
                g.setClip(actionRect);
                this.paintSmallSelectedBackground(g, x, y, width, height);
                g.setClip(popupRect);
                if (this.isRollover && !this.isPopupRollover) {
                    this.paintSmallRolloverBackground(g, x, y, width, height, true, this.isPopupEnabled);
                } else if (this.isPopupRollover) {
                    this.paintSmallRolloverBackground(g, x, y, width, height, false, this.isPopupEnabled);
                } else {
                    this.paintSmallSelectedBackground(g, x, y, width, height);
                }
            }
        }
    }

    private void paintSmallSelectedBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintSmallSelectedBackground((Graphics2D)g2d, (int)x, (int)y, (int)width, (int)height, (boolean)this.isInStrip, (boolean)this.isFirstInStrip, (boolean)this.isRollover);
    }

    private void paintBigSelectedBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintBigSelectedBackground((Graphics2D)g2d, (int)x, (int)y, (int)width, (int)height, (boolean)this.isRollover);
    }

    protected void paintPressedBackground(Graphics2D g, int x, int y, int width, int height) {
        Rectangle actionRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
        Rectangle popupRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
        if (this.commandButton.getDisplayState() == CommandButtonDisplayState.BIG) {
            if (!this.isSplit()) {
                ButtonPainter.paintBigPressedBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height);
            } else {
                actionRect.height += 2;
                popupRect.y += 2;
                popupRect.height -= 2;
                g.setClip(actionRect);
                if (this.isPopupRollover) {
                    ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)true, (boolean)this.isActionEnabled);
                } else {
                    ButtonPainter.paintBigPressedBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height);
                    g.setColor(new Color(-1711276033, true));
                    g.drawLine(x + 1, actionRect.height - 1, x + width - 2, actionRect.height - 1);
                }
                g.setClip(popupRect);
                if (this.isPopupRollover) {
                    ButtonPainter.paintBigPressedBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height);
                } else {
                    ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)true, (boolean)this.isPopupEnabled);
                }
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(g, x, y, width, height);
            }
            if (!this.isSplit()) {
                this.paintSmallPressedBackground(g, x, y, width, height);
            } else {
                g.setClip(actionRect);
                if (this.isPopupRollover) {
                    this.paintSmallRolloverBackground(g, x, y, width, height, true, this.isActionEnabled);
                } else {
                    this.paintSmallPressedBackground(g, x, y, width, height);
                }
                g.setClip(popupRect);
                if (this.isPopupRollover) {
                    this.paintSmallPressedBackground(g, x, y, width, height);
                } else {
                    this.paintSmallRolloverBackground(g, x, y, width, height, true, this.isPopupEnabled);
                }
            }
        }
    }

    private void paintSmallPressedBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintSmallPressedBackground((Graphics2D)g2d, (int)x, (int)y, (int)width, (int)height, (boolean)this.isInStrip, (boolean)this.isFirstInStrip, (boolean)this.isLastInStrip);
    }

    protected void paintRolloverBackground(Graphics2D g, int x, int y, int width, int height) {
        Rectangle actionRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
        Rectangle popupRect = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
        if (CommandButtonDisplayState.BIG == this.commandButton.getDisplayState()) {
            if (!this.isSplit()) {
                ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)false, (this.isActionEnabled || this.isPopupOnly && this.isPopupEnabled ? 1 : 0) != 0);
            } else {
                if (this.isPopupRollover) {
                    actionRect.height += 2;
                    popupRect.y += 2;
                    popupRect.height -= 2;
                }
                g.setClip(actionRect);
                ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)this.isPopupRollover, (boolean)this.isActionEnabled);
                g.setClip(popupRect);
                ButtonPainter.paintBigRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (!this.isPopupRollover ? 1 : 0) != 0, (boolean)this.isPopupEnabled);
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(g, x, y, width, height);
            }
            if (!this.isSplit()) {
                this.paintSmallRolloverBackground(g, x, y, width, height, false, this.isActionEnabled || this.isPopupOnly && this.isPopupEnabled);
            } else {
                g.setClip(actionRect);
                this.paintSmallRolloverBackground(g, x, y, width, height, this.isPopupRollover, this.isActionEnabled);
                g.setClip(popupRect);
                this.paintSmallRolloverBackground(g, x, y, width, height, !this.isPopupRollover, this.isPopupEnabled);
            }
        }
    }

    protected void paintSmallRolloverBackground(Graphics2D g, int x, int y, int width, int height, boolean overlay, boolean paintAsEnabled) {
        ButtonPainter.paintSmallRolloverBackground((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (boolean)overlay, (boolean)paintAsEnabled, (boolean)this.isInStrip, (boolean)this.isFirstInStrip, (boolean)this.isLastInStrip);
    }

    protected boolean isSplit() {
        JCommandButton.CommandButtonKind kind = this.commandButton instanceof JCommandButton ? ((JCommandButton)this.commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        return kind.hasAction() && kind.hasPopup();
    }

    public void paintCollapsedBandButtonBackground(Graphics g, Rectangle toFill) {
        this.updateState();
        Graphics2D g2d = (Graphics2D)g;
        if (this.isPressed) {
            this.paintPressedCollapsedBandButtonBackground(g2d, toFill.x, toFill.y, toFill.width, toFill.height);
        } else {
            this.paintNormalCollapsedBandButtonBackground(g2d, toFill.x, toFill.y, toFill.width, toFill.height);
        }
    }

    protected void paintPressedCollapsedBandButtonBackground(Graphics2D g2d, int x, int y, int width, int height) {
        Object oldAa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color[] colors = new Color[]{new Color(0xF3F3F3), new Color(13159892), new Color(12173513), new Color(0xECECEC)};
        g2d.setPaint(new LinearGradientPaint(x + 1, y + 1, x + 1, bottom - 1, new float[]{0.0f, 0.17f, 0.171f, 1.0f}, colors));
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        Composite old = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2d.setColor(new Color(0xAAAAAA));
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        g2d.setComposite(old);
        g2d.setColor(CollapsedBandColors.border1_pressed_140);
        g2d.drawLine(x + 1, y + 1, right - 1, y + 1);
        g2d.setColor(CollapsedBandColors.border1_pressed_90);
        g2d.drawLine(x + 1, y + 1, x + 1, bottom - 1);
        g2d.drawLine(x + 1, y + 2, right - 1, y + 2);
        g2d.setColor(CollapsedBandColors.border1_pressed_45);
        g2d.drawLine(x + 2, y + 1, x + 2, bottom - 1);
        g2d.drawLine(x + 1, y + 3, right - 1, y + 3);
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(new LinearGradientPaint(x, y, x, bottom, new float[]{0.0f, 0.95f, 1.0f}, new Color[]{CollapsedBandColors.border1_pressed, CollapsedBandColors.border2_pressed, CollapsedBandColors.border3_pressed}));
        this.drawRoundedRect(g2d, x, y, right, bottom);
        g2d.setPaint(oldPaint);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAa);
    }

    protected void paintNormalCollapsedBandButtonBackground(Graphics2D g2d, int x, int y, int width, int height) {
        Color[] colorArray;
        Color border2;
        Object oldAa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color border1 = this.isRollover ? CollapsedBandColors.border1_over : CollapsedBandColors.border1;
        Color color = border2 = this.isRollover ? CollapsedBandColors.border1_over : CollapsedBandColors.border1;
        if (this.isRollover) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(0xFFFFFF);
            colorArray2[1] = new Color(13685977);
            colorArray2[2] = new Color(12634063);
            colorArray = colorArray2;
            colorArray2[3] = new Color(0xF0F0F0);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(0xF3F3F3);
            colorArray3[1] = new Color(13159892);
            colorArray3[2] = new Color(12173513);
            colorArray = colorArray3;
            colorArray3[3] = new Color(0xECECEC);
        }
        Color[] colors = colorArray;
        g2d.setPaint(new LinearGradientPaint(x + 1, y + 1, x + 1, bottom - 1, new float[]{0.0f, 0.16f, 0.161f, 1.0f}, colors));
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(new LinearGradientPaint(x, y, x, bottom, new float[]{0.0f, 1.0f}, new Color[]{border1, border2}));
        this.drawRoundedRect(g2d, x, y, right, bottom);
        g2d.setPaint(oldPaint);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAa);
    }

    protected void drawRoundedRect(Graphics2D g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1 + 2, y1, x2 - 2, y1);
        g.drawLine(x1, y1 + 2, x1, y2 - 2);
        g.drawLine(x1 + 2, y2, x2 - 2, y2);
        g.drawLine(x2, y1 + 2, x2, y2 - 2);
        g.drawLine(x1, y1 + 2, x1 + 2, y1);
        g.drawLine(x2 - 2, y1, x2, y1 + 2);
        g.drawLine(x2, y2 - 2, x2 - 2, y2);
        g.drawLine(x1, y2 - 2, x1 + 2, y2);
    }

    protected void enableAA(Graphics2D g2d) {
        this.oldAa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void resetAA(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.oldAa);
    }

    static /* synthetic */ UIDefaults access$000() {
        return LAF;
    }

    static class CollapsedBandColors {
        protected static final Color border1 = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-color1");
        protected static final Color border2 = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-color2");
        protected static final Color border1_over = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-over-color1");
        protected static final Color border2_over = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-over-color2");
        protected static final Color border1_pressed = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-pressed-color1");
        protected static final Color border2_pressed = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-pressed-color2");
        protected static final Color border3_pressed = CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-border-pressed-color3");
        protected static final Color border1_pressed_140 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 140);
        protected static final Color border1_pressed_90 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 90);
        protected static final Color border1_pressed_45 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 45);
        protected static final Color highlight1 = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-highlight-color1"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-highlight-alpha1"));
        protected static final Color highlight2 = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-highlight-color2"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-highlight-alpha2"));
        protected static final Color highlight1_pressed = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-highlight-pressed-color1"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-highlight-pressed-alpha1"));
        protected static final Color highlight2_pressed = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-highlight-pressed-color2"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-highlight-pressed-alpha2"));
        protected static final Color background = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-background-color1"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-background-alpha1"));
        protected static final Color background_pressed = ColorUtil.setAlpha((Color)CommandButtonPainter.access$000().getColor("ribbon-button-collapsed-band-background-pressed-color1"), (int)CommandButtonPainter.access$000().getInt("ribbon-button-collapsed-band-background-pressed-alpha1"));

        CollapsedBandColors() {
        }
    }
}

