/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceLib {
    private static final Logger LOG = Logger.getLogger(ServiceLib.class.getName());

    private ServiceLib() {
    }

    static <T> T loadService(Class<T> ofType) {
        List<String> implClasses = ServiceLib.loadServicesImplementations(ofType);
        for (String implClass : implClasses) {
            T result = ServiceLib.attemptLoad(ofType, implClass);
            if (result == null) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Selected " + ofType.getSimpleName() + " implementation: " + result.getClass().getName());
            }
            return result;
        }
        throw new IllegalStateException("Could not load " + ofType.getName() + " implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadServicesImplementations(Class ofClass) {
        ArrayList<String> result = new ArrayList<String>();
        String override = System.getProperty(ofClass.getName());
        if (override != null) {
            result.add(override);
        }
        ClassLoader loader = ServiceLib.class.getClassLoader();
        URL url = loader.getResource("META-INF/services/" + ofClass.getName());
        InputStream inStream = null;
        InputStreamReader reader = null;
        BufferedReader bReader = null;
        try {
            String line;
            inStream = url.openStream();
            reader = new InputStreamReader(inStream);
            bReader = new BufferedReader(reader);
            while ((line = bReader.readLine()) != null) {
                if (line.matches("\\s*(#.*)?")) continue;
                result.add(line.trim());
            }
        }
        catch (IOException iox) {
            try {
                LOG.log(Level.WARNING, "Could not load services descriptor: " + url.toString(), iox);
            }
            catch (Throwable throwable) {
                ServiceLib.finalClose(bReader);
                ServiceLib.finalClose(reader);
                ServiceLib.finalClose(inStream);
                throw throwable;
            }
            ServiceLib.finalClose(bReader);
            ServiceLib.finalClose(reader);
            ServiceLib.finalClose(inStream);
        }
        ServiceLib.finalClose(bReader);
        ServiceLib.finalClose(reader);
        ServiceLib.finalClose(inStream);
        return result;
    }

    private static <T> T attemptLoad(Class<T> ofClass, String className) {
        ReflectiveOperationException thrown;
        Level level;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Attempting service load: " + className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (!ofClass.isAssignableFrom(clazz)) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning(clazz.getName() + " is not assignable to " + ofClass.getName());
                }
                return null;
            }
            return ofClass.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException ex) {
            level = Level.FINEST;
            thrown = ex;
        }
        catch (InstantiationException ex) {
            level = Level.WARNING;
            thrown = ex;
        }
        catch (IllegalAccessException ex) {
            level = Level.WARNING;
            thrown = ex;
        }
        LOG.log(level, "Could not load " + ofClass.getSimpleName() + " instance: " + className, thrown);
        return null;
    }

    private static void finalClose(Closeable closeMe) {
        if (closeMe != null) {
            try {
                closeMe.close();
            }
            catch (IOException iox) {
                LOG.log(Level.FINEST, "Could not close: " + closeMe, iox);
            }
        }
    }
}

