/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupCollection;
import com.paterva.maltego.typing.GroupCollections;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.GroupSet;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptors;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.ui.graph.transactions.properties.TransactionPropertySheetFactories;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public abstract class PartProperties {
    protected static final GroupCollection DYNAMIC_GROUP;
    protected static final String DYNAMIC_GROUP_NAME = "dynamic";
    protected static final String DISPLAY_IMAGE_ICON = "com/paterva/maltego/ui/graph/nodes/DisplayImage.png";
    protected static final ImageIcon EMPTY_ICON;

    protected PartProperties() {
    }

    private static PropertyConfiguration prepare(PropertyConfiguration spec, PropertyDescriptorCollection dynamicProperties) {
        PropertyConfiguration config = new PropertyConfiguration();
        if (spec == null) {
            config.setProperties(PartProperties.rewriteDynamicProperties(dynamicProperties));
        } else {
            config.setGroups(PartProperties.addDynamicGroup(spec.getGroups()));
            config.setProperties(PropertyDescriptors.add((DisplayDescriptorEnumeration)PartProperties.rewriteDynamicProperties(dynamicProperties), (DisplayDescriptorEnumeration)spec.getProperties()));
        }
        return config;
    }

    private static DisplayDescriptorEnumeration rewriteDynamicProperties(PropertyDescriptorCollection dynamicProperties) {
        DisplayDescriptorList list = new DisplayDescriptorList();
        for (PropertyDescriptor pd : dynamicProperties) {
            if (pd == null) continue;
            DisplayDescriptor dd = new DisplayDescriptor(pd);
            dd.setGroupName(DYNAMIC_GROUP_NAME);
            list.add(dd);
        }
        return list;
    }

    private static GroupDefinitions addDynamicGroup(GroupDefinitions spec) {
        if (spec == null) {
            return new GroupDefinitions(DYNAMIC_GROUP, null);
        }
        GroupDefinitions defs = new GroupDefinitions(GroupCollections.add((GroupCollection[])new GroupCollection[]{DYNAMIC_GROUP, spec.getTopLevelGroups()}), spec.getTopLevelSuperGroups());
        return defs;
    }

    public static void addProperties(PropertySheetFactory propertySheetFactory, SpecRegistry<? extends TypeSpec> registry, Sheet sheet, MaltegoPart<? extends Guid> part, PropertyConfiguration specPropertyConfig) {
        PropertyConfiguration config = PartProperties.combinePropertyConfigs(part, specPropertyConfig);
        for (PropertyDescriptor pd : config.getProperties()) {
            DisplayDescriptor dd = PartProperties.createDisplayDescriptor(pd);
            if (InheritanceHelper.isValueProperty(registry, part, (PropertyDescriptor)pd)) {
                dd.setHighlight(HighlightStyle.High);
            } else if (InheritanceHelper.isDisplayValueProperty(registry, part, (PropertyDescriptor)pd)) {
                dd.setHighlight(HighlightStyle.Medium);
            }
            if (part instanceof MaltegoEntity && InheritanceHelper.isImageProperty((EntityRegistry)((EntityRegistry)registry), (MaltegoEntity)((MaltegoEntity)part), (PropertyDescriptor)pd)) {
                dd.setImage(DISPLAY_IMAGE_ICON);
            }
            try {
                propertySheetFactory.addProperty(sheet, dd, part, config.getGroups());
            }
            catch (UnsupportedEditorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected static PropertyConfiguration combinePropertyConfigs(TypedPropertyBag propertyBag, PropertyConfiguration specPropertyConfig) {
        DisplayDescriptorEnumeration specProperties = specPropertyConfig == null ? null : specPropertyConfig.getProperties();
        PropertyDescriptorCollection properties = propertyBag.getProperties();
        PropertyDescriptorCollection instanceDynamic = PartProperties.getDynamicProperties(specProperties, properties, (DataSource)propertyBag);
        PropertyConfiguration config = PartProperties.prepare(specPropertyConfig, instanceDynamic);
        return config;
    }

    protected static DisplayDescriptor createDisplayDescriptor(PropertyDescriptor descriptor) {
        if (descriptor instanceof DisplayDescriptor) {
            return new DisplayDescriptor((DisplayDescriptor)descriptor);
        }
        return new DisplayDescriptor(descriptor);
    }

    private static PropertyDescriptorCollection getDynamicProperties(DisplayDescriptorEnumeration spec, PropertyDescriptorCollection instance, DataSource data) {
        if (spec == null) {
            return instance;
        }
        PropertyDescriptorList list = new PropertyDescriptorList();
        for (PropertyDescriptor pd : instance) {
            if (pd.isHidden()) continue;
            if (spec.contains(pd.getName())) {
                Object value;
                DisplayDescriptor specDescriptor = spec.get(pd.getName());
                if (pd.getType().isAssignableFrom(specDescriptor.getType()) || (value = data.getValue(pd)) == null) continue;
                try {
                    data.setValue((PropertyDescriptor)specDescriptor, Converter.convert((Object)value, (Class)pd.getType(), (Class)specDescriptor.getType()));
                }
                catch (IllegalArgumentException e2) {
                    Logger.getLogger(PartProperties.class.getName()).warning("incompatible entities/links with same type");
                }
                continue;
            }
            list.add(pd);
        }
        return list;
    }

    public static boolean isDynamicProperty(DisplayDescriptorProperty property) {
        return DYNAMIC_GROUP_NAME.equals(property.getDisplayDescriptor().getGroupName());
    }

    protected static PropertySheetFactory getPropertySheetFactory(GraphID graphID) {
        return graphID != null ? TransactionPropertySheetFactories.get(graphID) : PropertySheetFactory.getDefault();
    }

    static {
        EMPTY_ICON = new ImageIcon();
        DYNAMIC_GROUP = new GroupSet();
        DYNAMIC_GROUP.add(new Group(DYNAMIC_GROUP_NAME, "Dynamic properties", "Dynamic properties exist only in the instance and not in the definition."));
    }
}

