/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.FontUtils;

public class DisplayUtils {
    private static List<Image> zapIconImages;
    private static Boolean scaleImages;
    private static int iconSize;
    private static final int STD_HEIGHT = 16;

    private static int getIconSize() {
        if (scaleImages == null && (scaleImages = Boolean.valueOf(Model.getSingleton().getOptionsParam().getViewParam().isScaleImages())).booleanValue()) {
            iconSize = Model.getSingleton().getOptionsParam().getViewParam().getFontSize(FontUtils.FontType.general);
        }
        if (iconSize < 1 && (iconSize = Model.getSingleton().getOptionsParam().getViewParam().getIconSize()) < 1) {
            iconSize = 16;
        }
        return iconSize;
    }

    private static float getScale() {
        return Math.max(FontUtils.getScale(), (float)DisplayUtils.getIconSize() / 16.0f);
    }

    private static int getScaledIconWidth(Icon icon) {
        return DisplayUtils.getIconSize() * icon.getIconWidth() / icon.getIconHeight();
    }

    public static ImageIcon getScaledIcon(URL url) {
        if (url == null) {
            return null;
        }
        return DisplayUtils.getScaledIcon(new ImageIcon(url));
    }

    public static ImageIcon getScaledIcon(ImageIcon icon) {
        if (icon == null || icon.getIconHeight() > 16) {
            return icon;
        }
        return new ImageIcon(icon.getImage().getScaledInstance(DisplayUtils.getScaledIconWidth(icon), DisplayUtils.getIconSize(), 4));
    }

    public static Icon getScaledIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return icon;
        }
        return DisplayUtils.getScaledIcon((ImageIcon)icon);
    }

    public static Dimension getScaledDimension(int width, int height) {
        if (DisplayUtils.getScale() == 1.0f) {
            return new Dimension(width, height);
        }
        return new Dimension((int)((float)width * DisplayUtils.getScale()), (int)((float)height * DisplayUtils.getScale()));
    }

    public static int getScaledSize(int size) {
        return (int)((float)size * DisplayUtils.getScale());
    }

    public static void scaleIcon(JLabel label) {
        if (label != null && label.getIcon() instanceof ImageIcon) {
            label.setIcon(DisplayUtils.getScaledIcon((ImageIcon)label.getIcon()));
        }
    }

    public static void scaleIcon(JButton button) {
        if (button != null && button.getIcon() instanceof ImageIcon) {
            button.setIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getIcon()));
        }
    }

    public static void scaleIcon(JToggleButton button) {
        if (button != null) {
            if (button.getIcon() instanceof ImageIcon) {
                button.setIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getIcon()));
            }
            if (button.getSelectedIcon() instanceof ImageIcon) {
                button.setSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getSelectedIcon()));
            }
            if (button.getRolloverIcon() instanceof ImageIcon) {
                button.setRolloverIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getRolloverIcon()));
            }
            if (button.getRolloverSelectedIcon() instanceof ImageIcon) {
                button.setRolloverSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getRolloverSelectedIcon()));
            }
            if (button.getDisabledIcon() instanceof ImageIcon) {
                button.setDisabledIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getDisabledIcon()));
            }
            if (button.getDisabledSelectedIcon() instanceof ImageIcon) {
                button.setDisabledSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getDisabledSelectedIcon()));
            }
            if (button.getPressedIcon() instanceof ImageIcon) {
                button.setPressedIcon(DisplayUtils.getScaledIcon((ImageIcon)button.getPressedIcon()));
            }
        }
    }

    public static List<Image> getZapIconImages() {
        if (zapIconImages == null) {
            DisplayUtils.createZapIconImages();
        }
        return zapIconImages;
    }

    private static synchronized void createZapIconImages() {
        if (zapIconImages == null) {
            ArrayList<Image> images = new ArrayList<Image>(8);
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap16x16.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap32x32.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap48x48.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap64x64.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap128x128.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap256x256.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap512x512.png")));
            images.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap1024x1024.png")));
            zapIconImages = Collections.unmodifiableList(images);
        }
    }

    public static Insets getScaledInsets(int top, int left, int bottom, int right) {
        if (DisplayUtils.getScale() == 1.0f) {
            return new Insets(top, left, bottom, right);
        }
        return new Insets((int)((float)top * DisplayUtils.getScale()), (int)((float)left * DisplayUtils.getScale()), (int)((float)bottom * DisplayUtils.getScale()), (int)((float)right * DisplayUtils.getScale()));
    }

    public static boolean isDarkLookAndFeel() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof FlatLaf) {
            FlatLaf flaf = (FlatLaf)laf;
            return flaf.isDark();
        }
        return false;
    }

    public static Color getHighlightColor() {
        return DisplayUtils.isDarkLookAndFeel() ? new Color(102, 34, 0) : Color.LIGHT_GRAY;
    }

    static {
        scaleImages = null;
        iconSize = 0;
    }
}

