/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.ascan.AllCategoryTableModel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class PolicyAllCategoryPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PolicyAllCategoryPanel.class);
    private ZapTextField policyName = null;
    private JTable tableTest = null;
    private JScrollPane jScrollPane = null;
    private AllCategoryTableModel allCategoryTableModel = null;
    private JComboBox<String> policySelector = null;
    private JComboBox<String> comboThreshold = null;
    private JLabel labelThresholdNotes = null;
    private JComboBox<String> comboStrength = null;
    private JLabel labelStrengthNotes = null;
    private JComboBox<String> applyToThreshold = null;
    private JComboBox<String> applyToStrength = null;
    private JComboBox<String> applyToThresholdTarget = null;
    private JComboBox<String> applyToStrengthTarget = null;
    private ExtensionActiveScan extension;
    private ScanPolicy policy;
    private String currentName;
    private boolean switchable = false;
    private static final int[] width = new int[]{300, 100, 100};

    public PolicyAllCategoryPanel(Window parent, ExtensionActiveScan extension, ScanPolicy policy) {
        this(parent, extension, policy, false);
    }

    public PolicyAllCategoryPanel(Window parent, ExtensionActiveScan extension, ScanPolicy policy, boolean switchable) {
        this.extension = extension;
        this.policy = policy;
        this.currentName = policy.getName();
        this.switchable = switchable;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setSize(375, 205);
        this.setName("categoryPanel");
        int row = 0;
        this.add((Component)new JLabel(Constant.messages.getString("ascan.policy.name.label")), LayoutHelper.getGBC(0, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        if (this.switchable) {
            this.add(this.getPolicySelector(), LayoutHelper.getGBC(1, row, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        } else {
            this.add((Component)this.getPolicyName(), LayoutHelper.getGBC(1, row, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        }
        this.add((Component)new JLabel(Constant.messages.getString("ascan.options.level.label")), LayoutHelper.getGBC(0, ++row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add(this.getComboThreshold(), LayoutHelper.getGBC(1, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)this.getThresholdNotes(), LayoutHelper.getGBC(2, row, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)new JLabel(Constant.messages.getString("ascan.options.strength.label")), LayoutHelper.getGBC(0, ++row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add(this.getComboStrength(), LayoutHelper.getGBC(1, row, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)this.getStrengthNotes(), LayoutHelper.getGBC(2, row, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        JPanel applyToPanel = new JPanel();
        applyToPanel.setLayout(new GridBagLayout());
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.apply.label")), LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToThreshold(), LayoutHelper.getGBC(1, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.thresholdTo.label")), LayoutHelper.getGBC(2, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToThresholdTarget(), LayoutHelper.getGBC(3, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.rules.label")), LayoutHelper.getGBC(4, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        JButton applyThresholdButton = new JButton(Constant.messages.getString("ascan.options.go.button"));
        applyThresholdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyAllCategoryPanel.this.applyThreshold(PolicyAllCategoryPanel.this.strToThreshold((String)PolicyAllCategoryPanel.this.getApplyToThreshold().getSelectedItem()), (String)PolicyAllCategoryPanel.this.getApplyToThresholdTarget().getSelectedItem());
                PolicyAllCategoryPanel.this.getAllCategoryTableModel().fireTableDataChanged();
            }
        });
        applyToPanel.add((Component)applyThresholdButton, LayoutHelper.getGBC(5, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(6, 0, 1, 1.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.apply.label")), LayoutHelper.getGBC(0, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToStrength(), LayoutHelper.getGBC(1, 1, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.strengthTo.label")), LayoutHelper.getGBC(2, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToStrengthTarget(), LayoutHelper.getGBC(3, 1, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.rules.label")), LayoutHelper.getGBC(4, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        JButton applyStrengthButton = new JButton(Constant.messages.getString("ascan.options.go.button"));
        applyStrengthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyAllCategoryPanel.this.applyStrength(PolicyAllCategoryPanel.this.strToStrength((String)PolicyAllCategoryPanel.this.getApplyToStrength().getSelectedItem()), (String)PolicyAllCategoryPanel.this.getApplyToStrengthTarget().getSelectedItem());
                PolicyAllCategoryPanel.this.getAllCategoryTableModel().fireTableDataChanged();
            }
        });
        applyToPanel.add((Component)applyStrengthButton, LayoutHelper.getGBC(5, 1, 1, 0.0));
        applyToPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(6, 1, 1, 1.0));
        this.add((Component)applyToPanel, LayoutHelper.getGBC(0, ++row, 3, 0.0, 0.0, 1, new Insets(0, 0, 0, 0)));
        this.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, ++row, 3, 1.0, 1.0, 1, new Insets(0, 0, 0, 0)));
        this.setThreshold(this.policy.getDefaultThreshold());
        this.setStrength(this.policy.getDefaultStrength());
    }

    public void initialise(ScanPolicy policy) {
        this.getPolicyName().setText(policy.getName());
    }

    private ZapTextField getPolicyName() {
        if (this.policyName == null) {
            this.policyName = new ZapTextField();
            this.policyName.setText(this.policy.getName());
        }
        return this.policyName;
    }

    private JComboBox<String> getPolicySelector() {
        if (this.policySelector == null) {
            this.policySelector = new JComboBox();
            for (String policy : this.extension.getPolicyManager().getAllPolicyNames()) {
                this.policySelector.addItem(policy);
            }
            this.policySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String policyName = (String)PolicyAllCategoryPanel.this.policySelector.getSelectedItem();
                    if (policyName == null) {
                        return;
                    }
                    try {
                        ScanPolicy policy = PolicyAllCategoryPanel.this.extension.getPolicyManager().getPolicy(policyName);
                        if (policy != null) {
                            PolicyAllCategoryPanel.this.setScanPolicy(policy);
                        }
                    }
                    catch (ConfigurationException e1) {
                        LOGGER.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.policySelector;
    }

    public void reloadPolicies(String scanPolicyName) {
        DefaultComboBoxModel<String> policies = new DefaultComboBoxModel<String>();
        for (String policy : this.extension.getPolicyManager().getAllPolicyNames()) {
            policies.addElement(policy);
        }
        this.getPolicySelector().setModel(policies);
        this.getPolicySelector().setSelectedItem(scanPolicyName);
    }

    public void reloadPolicies() {
        Object selected = this.getPolicySelector().getSelectedItem();
        this.reloadPolicies((String)selected);
    }

    private Plugin.AlertThreshold strToThreshold(String str) {
        if (str.equals(Constant.messages.getString("ascan.options.level.off"))) {
            return Plugin.AlertThreshold.OFF;
        }
        if (str.equals(Constant.messages.getString("ascan.options.level.low"))) {
            return Plugin.AlertThreshold.LOW;
        }
        if (str.equals(Constant.messages.getString("ascan.options.level.medium"))) {
            return Plugin.AlertThreshold.MEDIUM;
        }
        if (str.equals(Constant.messages.getString("ascan.options.level.high"))) {
            return Plugin.AlertThreshold.HIGH;
        }
        return Plugin.AlertThreshold.DEFAULT;
    }

    private JComboBox<String> getApplyToThreshold() {
        if (this.applyToThreshold == null) {
            this.applyToThreshold = new JComboBox();
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.default"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.off"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.low"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.medium"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.high"));
        }
        return this.applyToThreshold;
    }

    private JComboBox<String> getApplyToThresholdTarget() {
        if (this.applyToThresholdTarget == null) {
            this.applyToThresholdTarget = this.createStatusComboBox();
        }
        return this.applyToThresholdTarget;
    }

    private JComboBox<String> createStatusComboBox() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(Constant.messages.getString("ascan.policy.table.status.all"));
        View view = View.getSingleton();
        comboBox.addItem(view.getStatusUI(AddOn.Status.release).toString());
        comboBox.addItem(view.getStatusUI(AddOn.Status.beta).toString());
        comboBox.addItem(view.getStatusUI(AddOn.Status.alpha).toString());
        return comboBox;
    }

    private void applyThreshold(Plugin.AlertThreshold threshold, String target) {
        for (Plugin plugin : this.policy.getPluginFactory().getAllPlugin()) {
            if (!this.hasSameStatus(plugin, target)) continue;
            plugin.setAlertThreshold(threshold);
        }
    }

    private boolean hasSameStatus(Plugin scanner, String status) {
        if (status.equals(Constant.messages.getString("ascan.policy.table.status.all"))) {
            return true;
        }
        return status.equals(View.getSingleton().getStatusUI(scanner.getStatus()).toString());
    }

    private Plugin.AttackStrength strToStrength(String str) {
        if (str.equals(Constant.messages.getString("ascan.options.strength.low"))) {
            return Plugin.AttackStrength.LOW;
        }
        if (str.equals(Constant.messages.getString("ascan.options.strength.medium"))) {
            return Plugin.AttackStrength.MEDIUM;
        }
        if (str.equals(Constant.messages.getString("ascan.options.strength.high"))) {
            return Plugin.AttackStrength.HIGH;
        }
        if (str.equals(Constant.messages.getString("ascan.options.strength.insane"))) {
            return Plugin.AttackStrength.INSANE;
        }
        return Plugin.AttackStrength.DEFAULT;
    }

    private JComboBox<String> getApplyToStrength() {
        if (this.applyToStrength == null) {
            this.applyToStrength = new JComboBox();
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.default"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.low"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.medium"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.high"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.insane"));
        }
        return this.applyToStrength;
    }

    private JComboBox<String> getApplyToStrengthTarget() {
        if (this.applyToStrengthTarget == null) {
            this.applyToStrengthTarget = this.createStatusComboBox();
        }
        return this.applyToStrengthTarget;
    }

    private void applyStrength(Plugin.AttackStrength strength, String target) {
        for (Plugin plugin : this.policy.getPluginFactory().getAllPlugin()) {
            if (!this.hasSameStatus(plugin, target)) continue;
            plugin.setAttackStrength(strength);
        }
    }

    private void setThreshold(Plugin.AlertThreshold threshold) {
        this.getComboThreshold().setSelectedItem(Constant.messages.getString("ascan.options.level." + threshold.name().toLowerCase(Locale.ROOT)));
        this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level." + threshold.name().toLowerCase(Locale.ROOT) + ".label"));
    }

    private void setStrength(Plugin.AttackStrength strength) {
        this.getComboStrength().setSelectedItem(Constant.messages.getString("ascan.options.strength." + strength.name().toLowerCase(Locale.ROOT)));
        this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength." + strength.name().toLowerCase(Locale.ROOT) + ".label"));
    }

    private JTable getTableTest() {
        if (this.tableTest == null) {
            this.tableTest = new JTable();
            this.tableTest.setModel(this.getAllCategoryTableModel());
            this.tableTest.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableTest.setIntercellSpacing(new Dimension(1, 1));
            this.tableTest.setAutoCreateRowSorter(true);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.tableTest.getRowSorter().setSortKeys(sortKeys);
            for (int i = 0; i < this.tableTest.getColumnCount() - 1; ++i) {
                Plugin.AlertThreshold[] column = this.tableTest.getColumnModel().getColumn(i);
                column.setPreferredWidth(width[i]);
            }
            JComboBox<String> jcb1 = new JComboBox<String>();
            jcb1.addItem("");
            for (Plugin.AlertThreshold level : Plugin.AlertThreshold.values()) {
                jcb1.addItem(Constant.messages.getString("ascan.policy.level." + level.name().toLowerCase(Locale.ROOT)));
            }
            this.tableTest.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jcb1));
            JComboBox<String> jcb2 = new JComboBox<String>();
            jcb2.addItem("");
            for (Plugin.AttackStrength level : Plugin.AttackStrength.values()) {
                jcb2.addItem(Constant.messages.getString("ascan.policy.level." + level.name().toLowerCase(Locale.ROOT)));
            }
            this.tableTest.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(jcb2));
        }
        return this.tableTest;
    }

    public void setScanPolicy(ScanPolicy scanPolicy) {
        if (!this.switchable) {
            throw new InvalidParameterException("Cannot change policy if the panel has not been defined as switchable");
        }
        this.getPolicySelector().setSelectedItem(scanPolicy.getName());
        this.policy = scanPolicy;
        this.setThreshold(scanPolicy.getDefaultThreshold());
        this.setStrength(scanPolicy.getDefaultStrength());
        this.getAllCategoryTableModel().setPluginFactory(scanPolicy.getPluginFactory());
        this.fireScanPolicyChanged(this.policy);
    }

    @Override
    public void initParam(Object obj) {
    }

    @Override
    public void validateParam(Object obj) throws Exception {
        String newName = this.getPolicyName().getText();
        if (newName.length() == 0) {
            this.getPolicyName().requestFocusInWindow();
            throw new Exception(Constant.messages.getString("ascan.policy.warn.noname"));
        }
        if (!this.extension.getPolicyManager().isLegalPolicyName(newName)) {
            this.getPolicyName().requestFocusInWindow();
            throw new Exception(Constant.messages.getString("ascan.policy.warn.badname", "/`?*\\<>|\":\t\n\r"));
        }
        if (!newName.equals(this.currentName)) {
            if (this.extension.getPolicyManager().getAllPolicyNames().stream().anyMatch(newName::equalsIgnoreCase)) {
                this.getPolicyName().requestFocusInWindow();
                throw new Exception(Constant.messages.getString("ascan.policy.warn.exists"));
            }
        }
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        this.policy.setName(this.getPolicyName().getText());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableTest());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private AllCategoryTableModel getAllCategoryTableModel() {
        if (this.allCategoryTableModel == null) {
            this.allCategoryTableModel = new AllCategoryTableModel(this.policy.getPluginFactory());
        }
        return this.allCategoryTableModel;
    }

    private JLabel getThresholdNotes() {
        if (this.labelThresholdNotes == null) {
            this.labelThresholdNotes = new JLabel();
        }
        return this.labelThresholdNotes;
    }

    private JComboBox<String> getComboThreshold() {
        if (this.comboThreshold == null) {
            this.comboThreshold = new JComboBox();
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.off"));
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.low"));
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.medium"));
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.high"));
            this.comboThreshold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PolicyAllCategoryPanel.this.comboThreshold.getSelectedItem().equals(Constant.messages.getString("ascan.options.level.off"))) {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.off.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.OFF);
                    } else if (PolicyAllCategoryPanel.this.comboThreshold.getSelectedItem().equals(Constant.messages.getString("ascan.options.level.low"))) {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.low.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.LOW);
                    } else if (PolicyAllCategoryPanel.this.comboThreshold.getSelectedItem().equals(Constant.messages.getString("ascan.options.level.medium"))) {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.medium.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
                    } else {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.high.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.HIGH);
                    }
                }
            });
        }
        return this.comboThreshold;
    }

    private JLabel getStrengthNotes() {
        if (this.labelStrengthNotes == null) {
            this.labelStrengthNotes = new JLabel();
        }
        return this.labelStrengthNotes;
    }

    private JComboBox<String> getComboStrength() {
        if (this.comboStrength == null) {
            this.comboStrength = new JComboBox();
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.low"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.medium"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.high"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.insane"));
            this.comboStrength.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.low"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.low.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.LOW);
                    } else if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.medium"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.medium.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
                    } else if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.high"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.high.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.HIGH);
                    } else {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.insane.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.INSANE);
                    }
                }
            });
        }
        return this.comboStrength;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicy";
    }

    public void addScanPolicyChangedEventListener(ScanPolicyChangedEventListener listener) {
        this.listenerList.add(ScanPolicyChangedEventListener.class, listener);
    }

    public void removeScanPolicyChangedEventListener(ScanPolicyChangedEventListener listener) {
        this.listenerList.remove(ScanPolicyChangedEventListener.class, listener);
    }

    private void fireScanPolicyChanged(ScanPolicy scanPolicy) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ScanPolicyChangedEventListener.class) continue;
            ((ScanPolicyChangedEventListener)listeners[i + 1]).scanPolicyChanged(scanPolicy);
        }
    }

    public static interface ScanPolicyChangedEventListener
    extends EventListener {
        public void scanPolicyChanged(ScanPolicy var1);
    }
}

