#!/usr/bin/env python2
"""Execute the tests for insegt.

The golden test outputs are generated by the script generate_outputs.sh.

You have to give the root paths to the source and the binaries as arguments to
the program.  These are the paths to the directory that contains the 'projects'
directory.

Usage:  run_tests.py SOURCE_ROOT_PATH BINARY_ROOT_PATH
"""
import logging
import os.path
import sys

# Automagically add util/py_lib to PYTHONPATH environment variable.
path = os.path.abspath(os.path.join(os.path.dirname(__file__), '..',
                                    '..', '..', 'util', 'py_lib'))
sys.path.insert(0, path)

import seqan.app_tests as app_tests

def main(source_base, binary_base):
    """Main entry point of the script."""

    print 'Executing test for insegt'
    print '========================='
    print
    
    ph = app_tests.TestPathHelper(
        source_base, binary_base,
        'apps/insegt/tests')  # tests dir

    # ============================================================
    # Auto-detect the binary path.
    # ============================================================

    path_to_program = app_tests.autolocateBinary(
      binary_base, 'bin', 'insegt')

    # ============================================================
    # Built TestConf list.
    # ============================================================

    # Build list with TestConf objects, analoguely to how the output
    # was generated in generate_outputs.sh.
    conf_list = []

    # ============================================================
    # First Section.
    # ============================================================

    # App TestConf objects to conf_list, just like this for each
    # test you want to run.
    conf = app_tests.TestConf(
        program=path_to_program,
        args=['-ro', ph.outFile('default_readOutput.gff'),
              '-ao', ph.outFile('default_annoOutput.gff'),
              '-to', ph.outFile('default_tupleOutput.gff'),
              ph.inFile('alignments.sam'),
              ph.inFile('annotations.gff')],
        to_diff=[(ph.inFile('default_annoOutput.gff'),
                  ph.outFile('default_annoOutput.gff')),
                 (ph.inFile('default_readOutput.gff'),
                  ph.outFile('default_readOutput.gff')),
                 (ph.inFile('default_tupleOutput.gff'),
                  ph.outFile('default_tupleOutput.gff'))])
    conf_list.append(conf)

    conf = app_tests.TestConf(
        program=path_to_program,
        args=['-c', str(2), 
              '-ro', ph.outFile('threshold-count2_readOutput.gff'),
              '-ao', ph.outFile('threshold-count2_annoOutput.gff'),
              '-to', ph.outFile('threshold-count2_tupleOutput.gff'),
              ph.inFile('alignments.sam'),
              ph.inFile('annotations.gff')],
        to_diff=[(ph.inFile('threshold-count2_annoOutput.gff'),
                  ph.outFile('threshold-count2_annoOutput.gff')),
                 (ph.inFile('threshold-count2_readOutput.gff'),
                  ph.outFile('threshold-count2_readOutput.gff')),
                 (ph.inFile('threshold-count2_tupleOutput.gff'),
                  ph.outFile('threshold-count2_tupleOutput.gff'))])
    conf_list.append(conf)

    conf = app_tests.TestConf(
        program=path_to_program,
        args=['-n', str(3), 
              '-ro', ph.outFile('ntuple3_readOutput.gff'),
              '-ao', ph.outFile('ntuple3_annoOutput.gff'),
              '-to', ph.outFile('ntuple3_tupleOutput.gff'),
              ph.inFile('alignments.sam'),
              ph.inFile('annotations.gff')],
        to_diff=[(ph.inFile('ntuple3_annoOutput.gff'),
                  ph.outFile('ntuple3_annoOutput.gff')),
                 (ph.inFile('ntuple3_readOutput.gff'),
                  ph.outFile('ntuple3_readOutput.gff')),
                 (ph.inFile('ntuple3_tupleOutput.gff'),
                  ph.outFile('ntuple3_tupleOutput.gff'))])
    conf_list.append(conf)

    conf = app_tests.TestConf(
        program=path_to_program,
        args=['-m', 
              '-ro', ph.outFile('max-tuple_readOutput.gff'),
              '-ao', ph.outFile('max-tuple_annoOutput.gff'),
              '-to', ph.outFile('max-tuple_tupleOutput.gff'),
              ph.inFile('alignments.sam'),
              ph.inFile('annotations.gff')],
        to_diff=[(ph.inFile('max-tuple_annoOutput.gff'),
                  ph.outFile('max-tuple_annoOutput.gff')),
                 (ph.inFile('max-tuple_readOutput.gff'),
                  ph.outFile('max-tuple_readOutput.gff')),
                 (ph.inFile('max-tuple_tupleOutput.gff'),
                  ph.outFile('max-tuple_tupleOutput.gff'))])
    conf_list.append(conf)

    conf = app_tests.TestConf(
        program=path_to_program,
        args=['-e', 
              '-ro', ph.outFile('exact-ntuple_readOutput.gff'),
              '-ao', ph.outFile('exact-ntuple_annoOutput.gff'),
              '-to', ph.outFile('exact-ntuple_tupleOutput.gff'),
              ph.inFile('alignments.sam'),
              ph.inFile('annotations.gff')],
        to_diff=[(ph.inFile('exact-ntuple_annoOutput.gff'),
                  ph.outFile('exact-ntuple_annoOutput.gff')),
                 (ph.inFile('exact-ntuple_readOutput.gff'),
                  ph.outFile('exact-ntuple_readOutput.gff')),
                 (ph.inFile('exact-ntuple_tupleOutput.gff'),
                  ph.outFile('exact-ntuple_tupleOutput.gff'))])
    conf_list.append(conf)

    # ============================================================
    # Execute the tests.
    # ============================================================
    failures = 0
    for conf in conf_list:
        res = app_tests.runTest(conf)
        # Output to the user.
        print ' '.join(['insegt'] + conf.args),
        if res:
             print 'OK'
        else:
            failures += 1
            print 'FAILED'

    # Cleanup.
    ph.deleteTempDir()

    print '=============================='
    print '     total tests: %d' % len(conf_list)
    print '    failed tests: %d' % failures
    print 'successful tests: %d' % (len(conf_list) - failures)
    print '=============================='
    # Compute and return return code.
    return failures != 0


if __name__ == '__main__':
    sys.exit(app_tests.main(main))
