///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//! @examplefile cosinusrad_error.cc The cosinus product function -- error analysis for the Poisson problem
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cosinusrad.h"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  Float error_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh; din >> uh;
  space Xh = uh.get_space();
  size_t d = Xh.get_geo().dimension();
  field pi_h_u = interpolate(Xh, u_exact(d));
  field eh = uh - pi_h_u;
  trial u (Xh); test v (Xh);
  form m = integrate (u*v);
  form a = integrate (dot(grad(u),grad(v)));
  dout << "error_l2   " << sqrt(m(eh,eh)) << endl
       << "error_linf " << eh.max_abs()   << endl
       << "error_h1   " << sqrt(a(eh,eh)) << endl;
  return (eh.max_abs() <= error_linf_expected) ? 0 : 1;
}
