% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_expr.R
\name{plot_expr}
\alias{plot_expr}
\title{Plot cRPKM values of a given gene}
\usage{
plot_expr(x, config = NULL, subg = FALSE, subg.show = c("mean", "all",
  "beeswarm"), trim_colnames = NULL, counts = FALSE,
  groupmean = ifelse(is.null(config), FALSE, TRUE), col = NULL,
  title = NULL, xlab = "", ylab = "Expression (cRPKM)", ylim = NULL,
  cex.main = 14, cex.yaxis = 12, cex.xaxis = 12, pch = 20,
  cex.pch = 3, plot = NULL, gridlines = TRUE, show_group_legend = TRUE)
}
\arguments{
\item{x}{A 1-row data frame containing cRPKM values to be plotted}

\item{config}{Optional configuration settings for \code{plot_expr}. Can be
a path to the \code{.config} file, or 4/5-column data frame of the \code{.config}
file. Use the latter option if you are calling \code{plot_expr} multiple times.}

\item{subg}{Logical indicating whether samples should be subgrouped for plotting.
If \code{TRUE}, the average of all samples in a subgroup is plotted as a single
data point. See \code{\link{plot_event}} and \code{\link{preprocess_sample_colors}}
for more details on subgrouping.}

\item{subg.show}{Only applies when \code{subg == TRUE}. Default is \code{mean},
in which the average PSI is computed for each subgroup. If \code{all}, then
individual point estimates with error bars are shown. If \code{beeswarm}, this is
similar to \code{all}, but shown as a beeswarm plot and without error bars.}

\item{trim_colnames}{String that must be searched for and trimmed at the end
of every sample column in x. Useful to trim the "-cRPKM" suffix from expression
tables. If no string must be trimmed, leave as \code{FALSE}.}

\item{counts}{Logical indicating whether the data frame contains read counts.
Set to \code{TRUE} if the data frame contains two rows per sample (cRPKM and
counts), otherwise leave as \code{FALSE} (default).}

\item{groupmean}{Logical indicating whether grouped means should be drawn.
Requires \code{config}.}

\item{col}{Vector of colors with length matching the number of samples. If
specified, this will override the color settings specified in \code{config}.}

\item{title}{Title of the plot. If \code{NULL} (default), the title will be
the content of the \code{ID} column in \code{x}.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{ylim}{Range of y-axis.}

\item{cex.main}{Plot title size (pts).}

\item{cex.yaxis}{Y-axis font size (pts).}

\item{cex.xaxis}{X-axis font size (i.e. the sample names) (pts).}

\item{pch}{Point symbol.}

\item{cex.pch}{Size of datapoints.}

\item{plot}{(deprecated) prints the plot.}

\item{gridlines}{Logical indicating whether grid lines should be drawn.}

\item{show_group_legend}{Set to FALSE to avoid showing a legend with the sample
groups and their colors.}
}
\value{
ggplot2 object.
}
\description{
Generate a plot of cRPKM values for a given gene. The cRPKM values are
obtained from the
\href{https://www.github.com/vastgroup/vast-tools}{vast-tools} pipeline.
}
\details{
Like \code{\link{plot_event}} and \code{\link{plot_multievent}}, plots can be
customized via the \code{config} option. Either a data frame or
the filepath to the config file can be used. Alternatively, plots can be
customized using a limited set of graphical parameters as described above.

See Details of \code{\link{plot_event}} and \code{\link{preprocess_sample_colors}}
for more information on customizing plots. Note that the \code{errorbar}
argument is not available for cRPKMs.

cRPKM values that have \emph{NA} value are omitted and not plotted.
}
\examples{
\dontrun{
plot_expr(crpkm[1,])

# Plot with custom configuration
config
plot_expr(crpkm[1,], config = config, groupmean=TRUE)
plot_expr(crpkm[1,], config = "/path/to/config")

# Plot using custom configuration, changing point symbol, and y-axis
# scale
plot_expr(crpkm[1,], config = config, pch = 9, ylim = c(20, 80))
}

# Plot with subgrouped samples
plot_expr(crpkm[1,], config=config, subg=TRUE)

# Plot directly from a table with suffixes and read counts
crpkm_counts
plot_expr(crpkm_counts[1,], config = config, trim_colnames = "-cRPKM", counts = TRUE)

}
\seealso{
\code{\link{format_table}} for performing some initial conversion steps of \code{x}

\code{\link{preprocess_sample_colors}} for pre-processing of \code{x} using
\code{config}
}
