% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.plots.R
\name{ascat.plotNonRounded}
\alias{ascat.plotNonRounded}
\title{ascat.plotNonRounded}
\usage{
ascat.plotNonRounded(
  ploidy,
  rho,
  goodnessOfFit,
  nonaberrant,
  nAfull,
  nBfull,
  y_limit = 5,
  bafsegmented,
  ch,
  lrr,
  chrs
)
}
\arguments{
\item{ploidy}{ploidy of the sample}

\item{rho}{purity of the sample}

\item{goodnessOfFit}{estimated goodness of fit}

\item{nonaberrant}{boolean flag denoting non-aberrated samples}

\item{nAfull}{copy number major allele}

\item{nBfull}{copy number minor allele}

\item{y_limit}{Optional parameter determining the size of the y axis in the nonrounded plot and ASCAT profile. Default=5}

\item{bafsegmented}{B Allele Frequency, segmented, in genomic sequence (only probes heterozygous in germline), with probe IDs}

\item{ch}{a list containing c vectors, where c is the number of chromosomes and every vector contains all probe numbers per chromosome}

\item{lrr}{(unsegmented) log R, in genomic sequence (all probes), with probe IDs}

\item{chrs}{a vector containing the names for the chromosomes (e.g. c(1:22,"X"))}
}
\value{
plot showing the nonrounded copy number profile, using base plotting function
}
\description{
Function plotting the unrounded ASCAT copy number over all chromosomes
}
