% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_auth.R
\name{gs4_deauth}
\alias{gs4_deauth}
\title{Suspend authorization}
\usage{
gs4_deauth()
}
\description{
Put googlesheets4 into a de-authorized state. Instead of sending a token,
googlesheets4 will send an API key. This can be used to access public
resources for which no Google sign-in is required. This is handy for using
googlesheets4 in a non-interactive setting to make requests that do not
require a token. It will prevent the attempt to obtain a token
interactively in the browser. The user can configure their own API key
via \code{\link[=gs4_auth_configure]{gs4_auth_configure()}} and retrieve that key via
\code{\link[=gs4_api_key]{gs4_api_key()}}.
In the absence of a user-configured key, a built-in default key is used.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gs4_deauth()
gs4_user()

# get metadata on the public 'deaths' spreadsheet
gs4_example("deaths") \%>\%
  gs4_get()
\dontshow{\}) # examplesIf}
}
\seealso{
Other auth functions: 
\code{\link{gs4_auth_configure}()},
\code{\link{gs4_auth}()}
}
\concept{auth functions}
