% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{plot.flextable}
\alias{plot.flextable}
\title{plot a flextable}
\usage{
\method{plot}{flextable}(x, method = c("grob", "webshot"), ...)
}
\arguments{
\item{x}{a flextable object}

\item{method}{the method to use for the plot, one of \code{grob} or \code{webshot}}

\item{...}{additional arguments passed to \code{\link[=gen_grob]{gen_grob()}} if method is 'grob'
and passed to \code{\link[=as_raster]{as_raster()}} if method is 'webshot'.}
}
\description{
plots a flextable, either as a grid grob object or as a raster image
and display the result in a new graphics window.
}
\details{
\itemize{
\item method \code{grob}, uses method \code{\link[=gen_grob]{gen_grob()}}
to convert the flextable into a grid graphics grob object.
\item method \code{webshot}, uses method \code{\link[=as_raster]{as_raster()}}
to convert the flextable into a raster object.
In that case packages \code{webshot} and \code{magick} are required.
}
}
\examples{
ftab <- flextable(head(mtcars))
ftab <- autofit(ftab)
\dontrun{
plot(ftab)
if (require("webshot")) {
  plot(ftab, method = "webshot")
}
}
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
