% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{validate_airr}
\alias{validate_airr}
\title{Validate an AIRR Data Model nested list representation}
\usage{
validate_airr(data, model = TRUE, each = FALSE)
}
\arguments{
\item{data}{\code{list} containing records of an AIRR Data Model objected imported from 
a YAML or JSON representation.}

\item{model}{if \code{TRUE} validate only AIRR DataFile defined objects. If \code{FALSE} 
attempt validation of all objects in \code{data}.}

\item{each}{if \code{TRUE} return a logical vector with results for each object in \code{data}
instead of a single \code{TRUE} or \code{FALSE} value.}
}
\value{
Returns \code{TRUE} if the input \code{data} is compliant with AIRR standards and
          \code{FALSE} if not. If \code{each=TRUE} is set, then a vector with results for each
          each object in \code{data} is returned instead.
}
\description{
\code{validate_airr} validates the fields in a named nested list representation of the 
AIRR Data Model. Typically, generating by reading of JSON or YAML formatted AIRR files.
}
\examples{
# Get path to the rearrangement-example file
f1 <- system.file("extdata", "repertoire-example.yaml", package="airr")
f2 <- system.file("extdata", "germline-example.json", package="airr")

# Load data file
repertoire <- read_airr(f1)
germline <- read_airr(f2)

# Validate a single record
validate_airr(repertoire)

# Return validation for individual objects
validate_airr(germline, each=TRUE)

}
\seealso{
See \link{Schema} for the AIRR schema definitions.
See \link{read_airr} for loading AIRR Data Models from a file.
See \link{write_airr} for writing AIRR Data Models to a file.
}
