% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareMOFA.R
\name{prepareMOFA}
\alias{prepareMOFA}
\title{prepare a MOFAobject for training}
\usage{
prepareMOFA(object, DataOptions = NULL, ModelOptions = NULL,
  TrainOptions = NULL)
}
\arguments{
\item{object}{an untrained \code{\link{MOFAmodel}}}

\item{DataOptions}{list of DataOptions (see \code{\link{getDefaultDataOptions}} details). 
If NULL, default data options are used.}

\item{ModelOptions}{list of ModelOptions (see \code{\link{getDefaultModelOptions}} for details). 
If NULL, default model options are used.}

\item{TrainOptions}{list of TrainOptions (see \code{\link{getDefaultTrainOptions}} for details). 
If NULL, default training options are used.}
}
\value{
Returns an untrained \code{\link{MOFAmodel}} with specified data, model and training options.
Next step is to train the model with \code{\link{runMOFA}}
}
\description{
Function to prepare a \code{\link{MOFAmodel}} object for training.
Here, data, input/output option are specified and data, model and training options can be set.
}
\examples{
# load data
data("CLL_data", package = "MOFAdata")
#create a MOFAmodel object
MOFAobject <- createMOFAobject(CLL_data)
# set options
TrainOptions <- getDefaultTrainOptions()
ModelOptions <- getDefaultModelOptions(MOFAobject)
DataOptions <- getDefaultDataOptions()
# prepare MOFAmodel object for training
MOFAobject <- prepareMOFA(MOFAobject, 
DataOptions = DataOptions,
ModelOptions = ModelOptions,
TrainOptions = TrainOptions
)
MOFAobject
}
