# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ContainerStateWaiting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'reason': 'str',
            'message': 'str'
        }

        self.attribute_map = {
            'reason': 'reason',
            'message': 'message'
        }

        self._reason = None
        self._message = None

    @property
    def reason(self):
        """
        Gets the reason of this V1ContainerStateWaiting.
        (brief) reason the container is not yet running.

        :return: The reason of this V1ContainerStateWaiting.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """
        Sets the reason of this V1ContainerStateWaiting.
        (brief) reason the container is not yet running.

        :param reason: The reason of this V1ContainerStateWaiting.
        :type: str
        """
        self._reason = reason

    @property
    def message(self):
        """
        Gets the message of this V1ContainerStateWaiting.
        Message regarding why the container is not yet running.

        :return: The message of this V1ContainerStateWaiting.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this V1ContainerStateWaiting.
        Message regarding why the container is not yet running.

        :param message: The message of this V1ContainerStateWaiting.
        :type: str
        """
        self._message = message

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
