# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class GovernanceRuleConditionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule Condition's Operator, for example Equals for severity or In for list of
    assessments, see examples.
    """

    #: Checks that the string value of the data defined in Property equals the given value - exact fit
    EQUALS = "Equals"
    #: Checks that the string value of the data defined in Property equals any of the given values
    #: (exact fit)
    IN = "In"


class GovernanceRuleOwnerSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The owner type for the governance rule owner source."""

    #: The rule source type defined using resource tag
    BY_TAG = "ByTag"
    #: The rule source type defined manually
    MANUALLY = "Manually"


class GovernanceRuleSourceResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule source, what the rule affects, e.g. Assessments."""

    #: The source of the governance rule is assessments
    ASSESSMENTS = "Assessments"


class GovernanceRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type of the governance rule, defines the source of the rule e.g. Integrated."""

    #: The source of the rule type definition is integrated
    INTEGRATED = "Integrated"
    #: The source of the rule type definition is ServiceNow
    SERVICE_NOW = "ServiceNow"
