/* Part of publib.

   Copyright (c) 1994-2006 Lars Wirzenius.  All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
   GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
 * strtabify.c -- convert runs of spaces and tabs to tabs (+ necessary spaces)
 *
 * Part of publib.  See man page for more information.
 * "@(#)publib-strutil:$Id: strtabify.c,v 1.1 1994/06/20 20:30:40 liw Exp $"
 */

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "publib/strutil.h"


#define nexttab(col)	((col) + tabsize - (col)%tabsize)


char *strtabify(char *str, size_t tabsize) {
	size_t scol, tcol;
	char *s, *t;

	tcol = scol = 0;
	t = s = str;
	do {
		switch (*s) {
		case ' ':
			++scol;
			break;
		case '\t':
			scol = nexttab(scol);
			break;
		default:
			while (nexttab(tcol) <= scol) {
				*t++ = '\t';
				tcol = nexttab(tcol);
			}
			while (tcol < scol) {
				*t++ = ' ';
				++tcol;
			}
			*t++ = *s;
			++scol;
			tcol = scol;
			break;
		}
	} while (*s++ != '\0');

	return str;
}
